package com.beiming.odr.referee.dto.responsedto;

import com.beiming.odr.referee.dto.DisputeAreaDTO;
import java.io.Serializable;
import java.util.List;
import lombok.Data;

/**
 * @Author: chenjt
 * @Description: 纠纷统计
 * @Date: Created 2018-07-04 21:14
 */
@Data
public class DisputeStatisticsResDTO implements Serializable {

  private static final long serialVersionUID = -575137161173232559L;
  /**
   * 当前地区名
   */
  private String areaName;
  /**
   * 纠纷总量
   */
  private Integer allNum;
  /**
   * 咨询总量
   */
  private Integer disputeCount;
  /**
   * 调解总量
   */
  private Integer lawCaseCount;
  /**
   * 调解案件成功数量
   */
  private Integer caseSuccessCount;

  /**
   * 调解案件失败数量
   */
  private Integer caseFailCount;

  /**
   * 诉讼案件数量
   */
  private Integer suitCount;

  /**
   * 司法确认案件数量
   */
  private Integer judicialCount;

  /**
   * XXX纠纷数量统计/业务类型调解统计
   */
  private List<StatisticsCountDateResDTO> lawCaseStatisticsList;
  /**
   * XXX业务类型咨询统计
   */
  private List<StatisticsCountDateResDTO> disputeStatisticsList;
  /**
   * XXX各区域纠纷类型统计
   */
  private List<StatisticsDisputeTypeAreaResDTO> disputeTypeAreaStatisticsList;
  /**
   * XXX各区域调解案件数量统计
   */
  private List<StatisticsOrgAreaResDTO> orgAreaStatisticsList;
  /**
   * 纠纷类型字典
   */
  private List<DictionaryInfoResDTO> disputeTypeList;
  /**
   * 纠纷区域列表
   */
  private List<DisputeAreaDTO> disputeAreaList;

}
