package com.beiming.odr.referee.dto.responsedto;

import com.beiming.odr.referee.enums.CaseProgressEnum;
import com.beiming.odr.referee.enums.MediationSuccessEnum;
import java.util.Date;
import lombok.Data;
import lombok.NoArgsConstructor;


@Data
@NoArgsConstructor
public class LawCaseCancelApplyAuditDTO {

  /**
   * 申请人信息
   */
  private Long creatorId;

  /**
   * 审核人信息
   */
  private Long updateId;

  /**
   * 案件编号
   */
  private String caseNo;

  /**
   * 案件id
   */
  private Long caseId;

  /**
   * 状态码(05纠纷被拒绝受理等)
   */
  private String lawCaseStatus;

  /**
   * 案件进度
   */
  private CaseProgressEnum caseProgress;

  /**
   * 撤回案件原因类型
   */
  private MediationSuccessEnum reasonType;

  /**
   * 撤回案件原因
   */
  private String reason;
  /**
   * 审核结果类型
   */
  private String auditResult;
  /**
   * 审核结果原因明细
   */
  private String auditResultDetail;


  private Long id;

  /**
   * 创建人
   */
  private String createUser;

  /**
   * 创建时间
   */
  private Date createTime;

  /**
   * 修改人
   */
  private String updateUser;

  /**
   * 修改时间
   */
  private Date updateTime;

  /**
   * 版本号
   */
  private Integer version;

  /**
   * 状态 0 正常 1 删除
   */
  private Integer status;

  /**
   * 备注
   */
  private String remark;
}
