package com.beiming.odr.referee.dto.responsedto;

import java.io.Serializable;
import lombok.Data;

/**
 * 案件与用户关系
 *
 * @author qsh
 * @data 2018年7月10日
 */
@Data
public class LawCasePersonResDTO implements Serializable {

  private static final long serialVersionUID = 1L;
  /**
   * 案件号
   */
  private String caseNum;

  /**
   * 案件id
   */
  private Long lawCaseId;

  /**
   * 用户id
   */
  private Long userId;

  /**
   * 案件用户类型（0：申请人 1：被申请人）
   */
  private String caseUserType;

  /**
   * 用户类型（0：自然人 1：法人 2：非法人组织）
   */
  private String userType;

  /**
   * 联系电话
   */
  private String phone;

  /**
   * 身份证号
   */
  private String idCard;

  /**
   * 代理人id
   */
  private String agentId;

  //代理人证件类型
  private String agentCardType;
  //国籍
  private String nationality;
  //代理人国籍
  private String agentNationality;
  //民族
  private String nation;
  //代理人民族
  private String agentNation;


  private String agentProvCode;

  private String agentCityCode;

  private String agentAreaCode;

  private String agentStreetCode;

  private String agentProvName;

  private String agentCityName;

  private String agentAreaName;

  private String agentStreetName;

  private String agentAddress;

  /**
   * 国家名称
   */
  private String agentNationName;

  /**
   * 国家code
   */
  private String agentNationCode;
}
