package com.beiming.odr.referee.dto.responsedto;

import com.beiming.odr.referee.enums.RegisterOriginEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 *
 * @author yi.liu
 */
@Data
public class LawCasePersonnelDTO implements Serializable {

  /**
   * 案件号
   */
  private String caseNum;
  /**
   * 案件id
   */
  private Long lawCaseId;
  /**
   * 案件文书id
   */
  private Long documentId;
  /**
   * 文书类型
   */
  private String documentType;
  /**
   * 用户id
   */
  private Long userId;
  /**
   * 案件用户类型（申请人 被申请人 调解员）
   */
  private String caseUserType;
  /**
   * 用户类型（0：自然人 1：法人 2：非法人组织）
   */
  private String userType;
  /**
   * 名称(类别为法人/非法人组织时, 填单位名称)
   */
  private String userName;
  /**
   * 性别
   */
  private String sex;
  /**
   * 联系电话
   */
  private String phone;
  /**
   * 身份证号
   */
  private String idCard;
  private String cardType;
  /**
   * 省份code
   */
  private String provCode;

  /**
   * 城市code
   */
  private String cityCode;
  /**
   * 区code
   */
  private String areaCode;

  /**
   * 街道code
   */
  private String streetCode;
  /**
   * 省份名称
   */
  private String provName;
  /**
   * 城市名称
   */
  private String cityName;
  /**
   * 区名称
   */
  private String areaName;

  /**
   * 街道名称
   */
  private String streetName;

  /**
   * 详细地址
   */
  private String address;

  /**
   * 信用代码
   */
  private String creditCode;

  /**
   * 法人代表
   */
  private String corporation;
  /**
   * 代理人id
   */
  private Long agentId;

  /**
   * 代理人类型
   */
  private String agentType;

  /**
   * 代理人姓名
   */
  private String agentName;

  /**
   * 代理人性别
   */
  private String agentSex;
  /**
   * 审批状态
   */
  private Integer approvalStatus;
  /**
   * 代理人审批状态
   */
  private Integer approvalAgentStatus;
  /**
   * 代理人联系电话
   */
  private String agentPhone;

  /**
   * 代理人身份证号
   */
  private String agentIdCard;
  /**
   * 排序
   */
  private Integer userOrder;

  /**
   * 代理人注册来源(0: 用户自己注册  1: 平台自动注册)
   */
  private RegisterOriginEnum agentRegisterOrigin;

  /**
   * 用户注册来源(0: 用户自己注册  1: 平台自动注册)
   */
  private RegisterOriginEnum userRegisterOrigin;

  /**
   * 固定电话
   */
  private String telephone;

  /**
   * 电子邮箱
   */
  private String email;

  /**
   * 引调当事人id
   */
  private String citePartyId;
  /**
   * 引调代理人id
   */
  private String citeAgentId;

  private String agentEmail;
  //代理人证件类型
  private String agentCardType;
  //国籍
  private String nationality;
  //代理人国籍
  private String agentNationality;
  //民族
  private String nation;
  //代理人民族
  private String agentNation;
  /**
   * 国家名称
   */
  private String nationName;

  /**
   * 国家code
   */
  private String nationCode;


  private String agentProvCode;

  private String agentCityCode;

  private String agentAreaCode;

  private String agentStreetCode;

  private String agentProvName;

  private String agentCityName;

  private String agentAreaName;

  private String agentStreetName;

  private String agentAddress;

  /**
   * 国家名称
   */
  private String agentNationName;

  /**
   * 国家code
   */
  private String agentNationCode;

  private Long id;

  /**
   * 创建人
   */
  private String createUser;

  /**
   * 创建时间
   */
  private Date createTime;

  /**
   * 修改人
   */
  private String updateUser;

  /**
   * 修改时间
   */
  private Date updateTime;

  /**
   * 版本号
   */
  private Integer version;

  /**
   * 状态 0 正常 1 删除
   */
  private Integer status;

  /**
   * 备注
   */
  private String remark;

}
