package com.beiming.odr.referee.dto.responsedto;

import java.io.Serializable;
import java.util.List;
import lombok.Data;

/**
 * @Description: 调解申请书返回实体
 * @Author: caiwei
 * @Date: Created 2018-08-09
 */
@Data
public class MediationApplyBookResDTO implements Serializable {
  private static final long serialVersionUID = 188497854141497799L;
  private Long caseId;

  /**
   * 协议书id
   */
  private Long docId;

  /**
   * 申请方
   */
  private List<CaseProtocolPersonnelResDTO> applicantList;

  /**
   * 被申请方
   */
  private List<CaseProtocolPersonnelResDTO> respondentList;

  /**
   * 请求事项
   */
  private String requestContent = "确认申请人#pros#与#reps#于#date#达成的调解协议有效。";

  /**
   * 事实和理由
   */
  private String factAndReason = "#date#，申请人#pros#与#reps#经#orgName#主持调解，达成如下协议：";

  /**
   * 地区code
   */
  private String areaCode;

  /**
   * 地区名称
   */
  private String areaName;

  /**
   * 受理法院code
   */
  private String courtCode;

  /**
   * 受理法院名称
   */
  private String courtName;

  /**
   * 案由code
   */
  private String causeCode;

  /**
   * 案由
   */
  private String causeName;

  /**
   * 案件类型code(华宇)
   */
  private String caseTypeCode;

  /**
   * 案件类型名称(华宇)
   */
  private String caseTypeName;

  /**
   * 是否已发送
   */
  private String sendStatus;

  /**
   * 相关人员签名详情
   */
  private List<CaseWholeConfirmResDTO> confirmList;
}
