package com.beiming.odr.referee.dto.responsedto;

import com.beiming.odr.referee.dto.MediationCasePersonnelDTO;
import com.beiming.odr.referee.dto.MediationCaseProgressDTO;
import com.beiming.odr.referee.dto.PetitionAgentDTO;
import com.beiming.odr.referee.enums.UserRoleEnum;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 调解信息查看响应参数
 *
 * @author DJQ 2018年6月27日
 *
 */
@Data
@NoArgsConstructor
public class MediationInfoResDTO implements Serializable {

  private static final long serialVersionUID = -2185513732200103145L;

  private String currentCaseUserType; // 当前用户案件内的角色类型

  private Long caseId; // 案件ID
  private String caseNo; // 案件号
  /**
   * @see UserRoleEnum
   */
  private String creatorType; // 案件录入人的身份
  private Long creatorId;
  private Long createTime; // 登记时间
  private String lawCaseStatus; // 案件状态
  private String lawCaseStatusCode; // 案件状态

  private String origin; // 案件来源
  private Long orgId; // 调解机构ID
  private String orgName; // 调解机构
  private String orgAreaCode; // 调解机构区域Code
  private Boolean orgConfirm; // 机构受理状态
  private String appeal; // 申请人诉求

  private String mediationType; // 调解类型
  private String disputeType; // 纠纷类型
  private String disputeTypeCode; // 纠纷类型Code
  private String disputeContent; // 纠纷描述

  private String tab; // 重新分配的标签 2018.10.10

  private String provCode; // 发生地代号：省
  private String cityCode; // 发生地代号：市
  private String areaCode; // 发生地代号：区
  private String streetCode; // 发生地代号：街道
  private String communityCode; // 生地代号：社区

  private String provName; // 发生地名称：省
  private String cityName; // 发生地名称：市
  private String areaName; // 发生地名称：区
  private String streetName; // 发生地名称：街道
  private String communityName; // 发生地名称：社区
  private String address; // 详细地址

  /**
   * 国家名称
   */
  private String nationName;

  /**
   * 国家code
   */
  private String nationCode;



  private List<MediationCasePersonnelDTO> applicants; // 申请人 + agentApplicants 申请人代理人
  private List<MediationCasePersonnelDTO> respondents; // 被申请人 + agentRespondents 被申请人代理人
  private PetitionAgentDTO petitionAgentUser; // 信访代理人
  private List<MediationActualResDTO> mediators; // 调解员
  private List<MediationCaseProgressDTO> progress; // 案件进度
  private List<CaseMaterialResDTO> documents; // 案件材料
  private ArrayList<CaseMeetingListResDTO> videos; // 调解记录（视频会议记录）
  private List<WorkbenchDocStatusResDTO> workbenchs; // 工作台信息：调解协议书、无异议调解方案、无争议事实确认协议
  private Boolean extendable; //是否可以申请延期
  private Boolean extendConformable; //是否可以确认延期
  private String citeCaseType;

  private String cancelAudit;
}
