package com.beiming.odr.referee.dto.responsedto;

import com.beiming.odr.referee.dto.MediationCasePersonnelDTO;
import com.beiming.odr.referee.dto.MediationCaseProgressDTO;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 调解列表
 *
 * @author DJQ 2018年6月24日
 *
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class MediationListResDTO implements Serializable {

  private static final long serialVersionUID = -2326143176608490189L;

  private Long caseId; // 案件ID
  private String caseNo; // 案件号
  private Date createTime; // 登记时间
  private String lawCaseStatus; // 案件状态

  private String origin; // 案件来源
  private Long orgId; // 机构ID
  private Boolean orgConfirm;
  private String orgName; // 调解机构
  private String appeal; // 申请人诉求

  private String mediationType; // 调解类型
  private String disputeType; // 纠纷类型
  private String disputeTypeCode; // 纠纷类型code
  private String disputeContent; // 纠纷描述

  private Long creatorId; // 案件录入人的ID
  private String creatorType; // 案件录入人的身份
  private Date startTime; // 调解开始时间

  private String provCode; // 发生地代号：省
  private String cityCode; // 发生地代号：市
  private String areaCode; // 发生地代号：区
  private String streetCode; // 发生地代号：街道
  private String communityCode; // 发生地代号：社区

  private String provName; // 发生地名称：省
  private String cityName; // 发生地名称：市
  private String areaName; // 发生地名称：区
  private String streetName; // 发生地名称：街道
  private String communityName; // 发生地名称：社区
  private String address; // 详细地址

  private Boolean allowCancel; // 是否允许撤回 true允许撤回，false不允许撤回（默认为false）

  private List<MediationCaseProgressDTO> progress; // 案件进度

  private List<MediationCasePersonnelDTO> applicants; // 申请人
  private List<MediationCasePersonnelDTO> respondents; // 被申请人
  private List<MediationActualResDTO> mediators; // 调解员

  private Long petitionAgentUserId; // 信访代理人Id
  private String petitionAgentUserName; // 信访代理人名字

  /**
   * 调解时间延长状态
   */
  private String extendStatus;

  /**
   * 调解时间延长确认状态
   */
  private String confirmStatus;
  /**
   * 调解时间延长天数
   */
  private Integer extendDay;
  /**
   * 延期原因
   */
  private String extendReason;

  private Date mediationDeadline;

  /**
   *延期表id
   */
  private Long extendId;

  private Boolean isSuspend;

  private Integer suspendNum;
  private String citeCaseType;


  private String cancelAudit;
}
