package com.beiming.odr.referee.dto.responsedto;

import java.io.Serializable;
import java.util.List;
import lombok.Data;

/**
 * 获取调解笔录的响应对象
 *
 * @author DJQ 2018年6月26日
 *
 */
@Data
public class MediationRecordGetResDTO implements Serializable {

  private static final long serialVersionUID = -5839195949001032307L;

  private Long documentId; // ID
  private Long lawCaseId;
  private String caseNo; // 案件号
  private String disputeType; // 纠纷类型
  private String disputeTypeCode; // 纠纷类型码
  private String content; // 笔录内容
  private String sendStatus; // 是否已发送
  private String time; // 时间
  private String location; // 地点
  private String remark; // 备注
  private Integer status; // 是否失效
  private List<ClerkConfirmAllResDTO> lawWholeConfirms; // 相关人员确认情况
  private List<MediationPersonalResDTO> mediationParticipants; // 会议参与人信息（调解员，自己存一份）

}
