package com.beiming.odr.referee.enums;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

/**
 * @Description: 案件状态枚举
 * @Author: caiwei
 * @Date: Created 2018-06-21
 */
public enum CaseStatusEnum {
  UNSUBMIT("案件未提交"),
  REFUSE_ACCEPTANCE("不受理"),
  APPLY_SUBMIT("案件申请提交"),
  WAIT_ALLOCATED_TO_MEDIATION_AGENCY("已分配给调解机构"),
  WAIT_TRANSFER_TO_MEDIATION_AGENCY("转移调解机构"),
  WAIT_ASSIGNED_TO_MEDIATOR("已分配给调解员"),
  WAIT_MEDIATOR_REALLOCATE("纠纷等待分配"),
  //  WAIT_UNABLE_MEDIATION("无法调解"),
  WAIT_MEDIATOR_CHECK_CASE_DATA("调解员查看案件资料"),
  WAIT_CASE_ACCEPTANCE("案件受理"),
  WAIT_SUSPEND_MEDIATION("调解终止"),
  START_ORDER_MEDIATION_TIME("已预约调解时间"),
  START_ORDER_VIDEO_RESEARCH("已经预约视频调查"),
  START_INVITE_VIDEO_RESEARCH("调解员邀请观摩人"),
  START_MEDIATOR_SEND_RESEARCH_RECORD("调解员发送调查笔录"),
  START_VIDEO_MEDIATION_START("视频调解或调查开始"),
  START_VIDEO_MEDIATION_END("视频调解或调查结束"),
  START_MEDIATION_PROTOCOL_MEDIATOR_SEND("调解员发送调解协议书"),
  START_MEDIATION_PROTOCOL_CONFIRM_FAIL("调解协议确认失败"),
  START_MEDIATION_PROTOCOL_CONFIRM_SUCCESS("调解协议确认成功"),
  START_MEDIATION_PROTOCOL_ONE_REFUSE("一方拒绝了调解协议"),
  START_MEDIATION_PROTOCOL_ONE_CONFIRM("一方确认了调解协议"),
  START_UNDISPUTED_FACTS_CONFIRM("确认了无争议事实"),
  START_UNDISPUTED_FACTS_REFUSE("拒绝了无争议事实"),
  START_UNDISPUTED_FACTS_CONFIRM_SUCCESS("无争议事实确认成功"),
  START_UNDISPUTED_FACTS_CONFIRM_FAIL("无争议事实确认失败"),
  START_UNDISPUTED_FACTS_MEDIATOR_SEND("调解员发送了无争议事实"),
  START_NO_OBJECTION_MEDIATION_SCHEME_SEND("发送了无异议调解方案"),
  START_PROMISE_ONE_CONFIRM("一方确认承诺书"),
  START_PROMISE_ONE_REFUSE("一方拒绝承诺书"),
  START_MEDIATION_SCHEME_ONE_CONFIRM("一方同意了调解方案"),
  START_MEDIATION_SCHEME_ONE_REFUSE("一方拒绝了调解方案并且提出了异议书"),
  START_MEDIATION_SCHEME_CONFIRM_SUCCESS("无异议调解方案确认成功"),
  START_MEDIATION_SCHEME_CONFIRM_FAIL("无异议调解方案确认失败"),
  START_ORDER_UNDER_LINE_MEETING_TIME("预约线下会议时间"),
  START_MEDIATION_RECORD_REFUSE("当事人拒绝了调解（调查）笔录"),
  START_MEDIATION_RECORD_AGREE("当事人同意了调解（调查）笔录"),
  RETRACT_CANCEL_CASE("撤回调解案件"),
  AUDIT_RETRACT_CANCEL_CASE("调解员申请撤回案件调解"),
  AUDIT_RETRACT_CANCEL_CASE_SUCCESS("已通过调解员申请撤回案件调解"),
  AUDIT_RETRACT_CANCEL_CASE_FAIL("不通过调解员申请撤回案件调解"),

  FAIL_MEDIATION("调解失败"),
  FAIL_EXCEED_MEDIATION_TERM("超过调解期限"),
  FAIL_SUIT_APPLY("已申请诉讼"),
  SUCCESS_MEDIATION("调解成功"),
  SUCCESS_JUDICIAL_CONFIRM_APPLY_SEND("调解员发送了申请司法确认申请书"),
  SUCCESS_JUDICIAL_CONFIRM_APPLY_CONFIRM("确认了申请司法确认申请书"),
  SUCCESS_JUDICIAL_CONFIRM_REFUSE_APPLY("拒绝了申请司法确认申请书"),
  SUCCESS_JUDICIAL_CONFIRM_APPLY_SUCCESS("申请司法确认申请确认成功"),
  SUCCESS_JUDICIAL_CONFIRM_APPLY_FAIL("申请司法确认申请确认失败"),
  SUCCESS_JUDICIAL_CONFIRM_APPLY("已申请司法确认"),
  SUCCESS_JUDICIAL_CONFIRM_SUCCESS("申请司法确认通过"),
  SUCCESS_JUDICIAL_CONFIRM_FAIL("申请司法确认不通过"),
  SUCCESS_WITHDRAW_APPLY("已申请撤回诉讼"),
  SUCCESS_WITHDRAW_SUCCESS("申请撤回诉讼成功"),
  SUCCESS_WITHDRAW_FAIL("申请撤回诉讼失败"),
  SUCCESS_MEDIATION_APPLY_SEND("调解员发送了申请调解申请书"),
  SUCCESS_MEDIATION_APPLY_CONFIRM("确认了申请调解申请书"),
  SUCCESS_MEDIATION_APPLY_REFUSE("拒绝了申请调解申请书"),
  SUCCESS_MEDIATION_APPLY_SUCCESS("申请调解申请确认成功"),
  SUCCESS_MEDIATION_APPLY_FAIL("申请调解申请确认失败"),
  SUCCESS_MEDIATION_APPLY_TO_COURT("已向审判中心发起调解申请书申请"),
  SUCCESS_MEDIATION_APPLY_TO_COURT_SUCCESS("向审判中心发起调解申请书申请通过"),
  SUCCESS_MEDIATION_APPLY_TO_COURT_FAIL("向审判中心发起调解申请书申请不通过"),
  START_MEDIATION_EXTEND_APPLY("调解员发起了调解期限延长申请"),
  START_MEDIATION_EXTEND_APPLY_AGREE("同意了调解期限延长申请"),
  START_MEDIATION_EXTEND_APPLY_REJECT("拒绝了调解期限延长申请"),
  START_MEDIATION_EXTEND_APPLY_SUCCESS("调解期限延长申请确认成功"),
  START_MEDIATION_EXTEND_APPLY_FAIL("调解期限延长申请确认失败"),
  SUCCESS_ARBITRATE_APPLY("调解成功转仲裁"),
  FAIL_ARBITRATE_APPLY("调解失败转仲裁");

  private String name;

  CaseStatusEnum(String name) {
    this.name = name;
  }

  public String getName() {
    return name;
  }

  /**
   * 根据状态前缀获取进度枚举值
   */
  public static CaseProgressEnum getCaseProgressEnum(CaseStatusEnum caseStatusEnum) {
    String name = caseStatusEnum.name();
    if (name.indexOf("_") != -1) {
      String caseStatusEnumPre = name.substring(0, name.indexOf("_"));
      return CaseProgressEnum.valueOf(caseStatusEnumPre);
    }
    return CaseProgressEnum.valueOf(name);
  }

  /**
   * 根据进度查询状态
   */
  public static List<CaseStatusEnum> queryCaseStatusEnumLst(CaseProgressEnum caseProgressEnum) {
    List<CaseStatusEnum> result = new ArrayList<CaseStatusEnum>();

    EnumSet<CaseStatusEnum> caseStatusEnumSet = EnumSet.allOf(CaseStatusEnum.class);
    for (CaseStatusEnum tmp : caseStatusEnumSet) {
      if (tmp.name().startsWith(caseProgressEnum.name())) {
        result.add(tmp);
      }
    }
    return result;
  }
  /**
   * 获取已经进行过诉讼/司法/仲裁的案件
   */
  public static List<String> querySuitCaseStatus() {
    List<String> suitCaseStatusList = new ArrayList<>();
    suitCaseStatusList.add(CaseStatusEnum.FAIL_SUIT_APPLY.name());
    suitCaseStatusList.add(CaseStatusEnum.SUCCESS_JUDICIAL_CONFIRM_APPLY.name());
    suitCaseStatusList.add(CaseStatusEnum.SUCCESS_MEDIATION_APPLY_TO_COURT.name());
    suitCaseStatusList.add(CaseStatusEnum.FAIL_SUIT_APPLY.name());
    suitCaseStatusList.add(CaseStatusEnum.SUCCESS_ARBITRATE_APPLY.name());
    suitCaseStatusList.add(CaseStatusEnum.FAIL_ARBITRATE_APPLY.name());
    return  suitCaseStatusList;
  }

}
