package com.beiming.odr.referee.enums;

/**
 * @Description: 案件用户类型
 * @Author: caiwei
 * @Date: Created 2018-06-21
 */
public enum CaseUserTypeEnum {
  APPLICANT("申请人", "15_Z00099-4"), RESPONDENT("被申请人", "15_Z00099-5"), MEDIATOR("调解员",
      ""), APPLICANT_AGENT("申请人代理人", ""), RESPONDENT_AGENT("被申请人代理人", ""),
  PETITION_AGENT("信访代理人", ""), GENERAL_AGENT("一般代理人", ""), PRIVILEGE_AGENT("特权代理人", "");

  private String name;
  private String tdhCode;

  CaseUserTypeEnum(String name, String tdhCode) {
    this.name = name;
    this.tdhCode = tdhCode;
  }

  public String getName() {
    return name;
  }

  public String getTdhCode() {
    return tdhCode;
  }

  public void setTdhCode(String tdhCode) {
    this.tdhCode = tdhCode;
  }

  private static String getNameWithValue(String value) {
    CaseUserTypeEnum[] values = values();
    for (CaseUserTypeEnum caseUserTypeEnum : values) {
      if (caseUserTypeEnum.name().equals(value)) {
        return caseUserTypeEnum.getName();
      }
    }
    return "";
  }
}
