package com.beiming.odr.referee.enums;

/**
 * @Description: 文书类型枚举
 * @Author: caiwei
 * @Date: Created 2018-06-21
 */
public enum DocumentTypeEnum {
  MEDIATION_BOOK("调解协议书"), COMMITMENT_BOOK("承诺书"), NO_DISSENT_MEDIATION_SCHEME(
      "无异议调解方案"), UNDISPUTED_FACT("无争议事实确认协议"), MEDIATION_RECORD("调解笔录"), INQUIRE_RECORD(
          "调查笔录"), DISSENT_RECORD("异议书"), JUDICIAL_CONFIRM_APPLY_BOOK("申请司法确认书"),
            FINAL_MEDIATION_REPORT("终结调解报告"), MEDIATION_APPLY_BOOK("请求法院出具调解书"),
            RECONCILIATION_AGREEMENT("调解书"), WITHDRAW_CASE("撤回立案"), JUDICIAL_CONFIRM_BOOK("司法确认书"),
            CLOSE_CASE_BOOK("诉中结案文书");

  private String name;

  DocumentTypeEnum(String name) {
    this.name = name;
  }

  public static boolean noMsgDoc(String docType) {
    return !DocumentTypeEnum.MEDIATION_RECORD.name().equals(docType)
            && !DocumentTypeEnum.MEDIATION_BOOK.name().equals(docType) && !DocumentTypeEnum.UNDISPUTED_FACT.name().equals(docType)
            && !DocumentTypeEnum.NO_DISSENT_MEDIATION_SCHEME.name().equals(docType);
  }

  public String getName() {
    return name;
  }

  /**
   * 判断是否为笔录类型文书
   * 
   * @param documentType
   * @return
   */
  public static Boolean isRecord(String documentType) {
    return DocumentTypeEnum.MEDIATION_RECORD.name().equalsIgnoreCase(documentType)
        || DocumentTypeEnum.INQUIRE_RECORD.name().equalsIgnoreCase(documentType);
  }

}
