package com.beiming.odr.referee.enums;

/**
 * Created by zli on 2018/7/20. USER 前缀为用户 LEGAL_PERSON 法人和非法人组织 AGENT 代理人 MEDIATOR 调解员
 *
 * 短信模版code
 */
public enum SMSCodeEnum {
  /**
   * 用户纠纷登记成功
   */
  USER_REGISTRATION_SUCCESS,
  /**
   * 通知单位纠纷登记成功
   */
  LEGAL_PERSON_REGISTRATION_SUCCESS,
  /**
   * 初次使用平台用户纠纷登记成功
   */
  USER_REGISTRATION_SUCCESS_FIRST,
  /**
   * 通知初次使用平台单位纠纷登记成功
   */
  LEGAL_PERSON_REGISTRATION_SUCCESS_FIRST,
  /**
   * 通知代理人纠纷登记成功
   */
  AGENT_REGISTRATION_SUCCESS,
  /**
   * 通知初次使用平台代理人纠纷登记成功
   */
  AGENT_REGISTRATION_SUCCESS_FIRST,
  /**
   * 通知机构管理员纠纷登记成功
   */
  ADMIN_REGISTRATION_SUCCESS,
  /**
   * 通知信访代理人纠纷登记成功
   */
  PETITION_AGENT_REGISTRATION_SUCCESS,
  /**
   * 通知用户纠纷指派到哪个机构的哪调解员——申请人
   */
  USER_ASSIGNED_ORG_APPLICANT,
  /**
   * 通知单位纠纷指派到哪个机构的哪调解员——申请人
   */
  LEGAL_PERSON_ASSIGNED_ORG_APPLICANT,
  /**
   * 通知申请人代理人纠纷指派给调解员
   */
  AGENT_ASSIGNED_ORG_MEDIATOR,
  /**
   * 通知被申请人代理人纠纷指派给调解员
   */
  AGENT_ASSIGNED_ORG_MEDIATOR_FIRST,
  /**
   * 通知被申请人新代理人纠纷指派给调解员
   */
  AGENT_ASSIGNED_ORG_RESPONDENT_FIRST,
  /**
   * 通知用户纠纷指派到哪个机构的哪调解员——被申请人
   */
  USER_ASSIGNED_ORG_RESPONDENT,
  /**
   * 通知用户纠纷指派到哪个机构的哪调解员——新被申请人
   */
  USER_ASSIGNED_ORG_RESPONDENT_FIRST,
  /**
   * 通知单位纠纷指派到哪个机构的哪调解员——被申请人
   */
  LEGAL_PERSON_ASSIGNED_ORG_RESPONDENT,
  /**
   * 通知单位纠纷指派到哪个机构的哪调解员——新被申请人
   */
  LEGAL_PERSON_ASSIGNED_ORG_RESPONDENT_FIRST,
  /**
   * 通知用户纠纷分配到调解员
   */
  USER_ASSIGNED_MEDIATOR,
  /**
   * 通知单位纠纷分配到调解员
   */
  LEGAL_PERSON_ASSIGNED_MEDIATOR,
  /**
   * 通知初次使用平台用户纠纷分配到调解员
   */
  USER_ASSIGNED_MEDIATOR_FIRST,
  /**
   * 通知单位纠纷分配到调解员
   */
  LEGAL_PERSON_ASSIGNED_MEDIATOR_FIRST,
  /**
   * 通知代理人调解员受理纠纷（新代理人）
   */
  AGENT_ASSIGNED_MEDIATOR_FIRST,
  /**
   * 通知用户调解预约时间
   */
  USER_MEDIATOR_APPOINTMENT,
  /**
   * 通知单位调解预约时间
   */
  LEGAL_PERSON_MEDIATOR_APPOINTMENT,
  /**
   * 通知代理人调解预约时间
   */
  AGENT_MEDIATOR_APPOINTMENT,
  /**
   * 通知用户调解预约时间（通知新用户）
   */
  USER_MEDIATOR_APPOINTMENT_FIRST,
  /**
   * 通知单位调解预约时间（通知新用户）
   */
  LEGAL_PERSON_MEDIATOR_APPOINTMENT_FIRST,
  /**
   * 通知代理人调解预约时间（通知新代理人）
   */
  AGENT_PERSON_MEDIATOR_APPOINTMENT_FIRST,
  /**
   * 预约线下会议
   */
  USER_ASSIGNED_OFFLINE_MEETING,
  /**
   * 预约线下会议
   */
  LEGAL_PERSON_ASSIGNED_OFFLINE_MEETING,
  /**
   * 通知代理人预约线下会议
   */
  AGENT_PERSON_ASSIGNED_OFFLINE_MEETING,
  /**
   * 通知用户调查预约时间
   */
  USER_SURVEY_APPOINTMENT,
  /**
   * 通知单位调查预约时间
   */
  LEGAL_PERSON_SURVEY_APPOINTMENT,
  /**
   * 通知代理人调查预约时间
   */
  AGENT_PERSON_SURVEY_APPOINTMENT,
  /**
   * 通知用户调查预约时间（通知新用户）
   */
  USER_SURVEY_APPOINTMENT_FIRST,
  /**
   * 通知单位调查预约时间（通知新用户）
   */
  LEGAL_PERSON_SURVEY_APPOINTMENT_FIRST,
  /**
   * 通知代理人调查预约时间（通知新代理人）
   */
  AGENT_PERSON_SURVEY_APPOINTMENT_FIRST,
  /**
   * 通知用户调解员发布协议
   */
  USER_NOTIFY_PUBLISH_MEDIATOR,
  /**
   * 通知单位调解员发布协议
   */
  MONAD_NOTIFY_PUBLISH_MEDIATOR,
  /**
   * 通知代理人调解员发布协议
   */
  AGENT_NOTIFY_PUBLISH_MEDIATOR,
  /**
   * 通知信访代理人调解员发布协议
   */
  AGENT_PETITION_NOTIFY_PUBLISH_MEDIATOR,
  /**
   * 通知用户调解成功
   */
  USER_NOTIFY_SUCCESSFUL_MEDIATION,
  /**
   * 通知代理单位调解成功
   */
  MONAD_NOTIFY_SUCCESSFUL_MEDIATION,
  /**
   * 通知代理人调解成功
   */
  AGENT_NOTIFY_SUCCESSFUL_MEDIATION,
  /**
   * 通知用户调解失败
   */
  USER_NOTIFY_FAIL_MEDIATOR,
  /**
   * 通知单位调解失败
   */
  LEGAL_PERSON_NOTIFY_FAIL_MEDIATION,
  /**
   * 通知代理人调解失败
   */
  AGENT_NOTIFY_FAIL_MEDIATOR,
  /**
   * 通知用户需要重新分配调解员
   */
  USER_NOTIFY__REALLOCATE_MEDIATOR,
  /**
   * 通知单位需要重新分配调解员
   */
  LEGAL_PERSON_NOTIFY__REALLOCATE_MEDIATOR,
  /**
   * 通知代理人需要重新分配调解员
   */
  AGENT_NOTIFY__REALLOCATE_MEDIATOR,
  // 管理员短信模板
  /**
   * 通知管理员上线
   */
  ADNIM_NOTIFY_ONLINE,
  /**
   * 通知机构管理人员有新的纠纷流入
   */
  ORGANIZATION_INFORM_NEW_DISPUTES,
  /**
   * 通知机构管理员其他机构有纠纷转入
   */
  ORGANIZATION_INFORM_OTHER_TRANSFER_DISPUTES,
  /**
   * 通知机构管理人员调解员申请重新分配
   */
  ORGANIZATION_APPLY_REDISTRIBUTION_MEDIATOR,
  /**
   * 通知机构管理员纠纷调解失败
   */
  ORGANIZATION_DISPUTES_FAIL_MEDIATOR,
  /**
   * 通知机构管理员纠纷调解成功
   */
  ORGANIZATION_DISPUTES_SUCCESSFUL_MEDIATOR,
  /**
   * 调解员邀请观摩人员参与调解会议
   */
  INVITED_MEETING_MEDIATOR,
  /**
   * 调解员邀请观摩人员参与调查会议
   */
  INVITED_MEETING_SURVEY,
  /**
   * 通知用户发送手机验证码
   */
  USER_NOTIFY_SEND_VERIFICATION_CODE,
  /**
   * 通知咨询师客服转接向转接了一条咨询
   */
  CUSTOMER_INFORM_TRANSFER_REFERRAL,

  /** ------------撤回调解短信-----------------*/
  /**
   * 第一个申请人为个人
   */
  CANCEL_CASE_NOTICE_FIRST_APPLICANT_PERSONAL,
  /**
   * 其他申请人为个人
   */
  CANCEL_CASE_NOTICE_OTHER_APPLICANT_PERSONAL,
  /**
   * 第一个申请人为企业
   */
  CANCEL_CASE_NOTICE_FIRST_APPLICANT_COMPANY,
  /**
   * 其他申请人为企业
   */
  CANCEL_CASE_NOTICE_OTHER_APPLICANT_COMPANY,
  /**
   * 申请人的代理人
   */
  CANCEL_CASE_NOTICE_APPLICANT_AGENT,
  /**
   * 被申请人为个人
   */
  CANCEL_CASE_NOTICE_RESPONDENT_PERSONAL,
  /**
   * 被申请人为企业
   */
  CANCEL_CASE_NOTICE_RESPONDENT_COMPANY,
  /**
   * 被申请人代理人
   */
  CANCEL_CASE_NOTICE_RESPONDENT_AGENT,

  /**
   * 撤回案件通知调解员
   */
  CANCEL_CASE_NOTICE_MEDIATOR,

  /**
   * 撤回案件通知机构管理员
   */
  CANCEL_CASE_NOTICE_ADMIN,
  /**
   * 撤回案件通知信访代理人
   */
  CANCEL_CASE_NOTICE_PETITION_AGENT,
  /**
   * 申请人不受理短信
   */
  USER_REJECT_COMPLAINT,

  // 通知调解员
  /**
   * 通知调解员机构分配了新的任务
   */
  MEDIATOR_ALLOCATION,
  /**
   * 信访代理人会议线下调查 调解 共用
   */
  AGENT_PETITION_OFFLINE_SURVEY_MEDIATOR,
  /**
   * 信访代理人会议调查 调解 共用
   */
  AGENT_PETITION_SURVEY_MEDIATOR,
  /**
   * 信访代理人调解失败
   */
  AGENT_PETITION_FAIL_MEDIATOR,
  /**
   * 信访代理人调解成功
   */
  AGENT_PETITION_SUCCESSFUL_MEDIATOR,
  /**
   * 通知信访代理人需要重新分配调解员
   */
  AGENT_PETITION_REALLOCATE_MEDIATOR,
  /**
   * 信访代理人不受理案件
   */
  AGENT_PETITION_REJECT_COMPLAINT,

  /**
   * 调解结案后，通知申请人评价调解员的短信
   */
  EVALUATE_MEDIATOR_APPLICANT_MESSAGE,
  /**
   * 调解结案后 ，通知被申请人评价调解员的短信
   */
  EVALUATE_MEDIATOR_REAPPLICANT_MESSAGE,
  /**
   * 调解结案后，通知信访委托人评价信访代理人的短信
   */
  AGENT_PETITION_APPLICANT_MESSAGE,
  /**
   * 调解结案后，通知被申请人评价信访代理人的短信
   */
  AGENT_PETITION_REAPPLICANT_MESSAGE,
  /**
   * 时间段
   */
  CASE_MONITOR_PAST_TIME,
  /**
   * 再过N天
   */
  CASE_MONITOR_AFTER_N_DAYS,
  /**
   * 新用户注册
   */
  USER_ACCOUNT_PASSWORD_TIPS,
  /**
   *通知管理员延长调解期限
   */
  ADMIN_EXTEND_SUCCESS,
  /**
   * 通知当事人自然人延长调解期限
   */
  PARTY_EXTEND_SUCCESS,
  /**
   * 通知当事人代理人延长调解期限
   */
  AGENT_EXTEND_SUCCESS,
  /**
   * 通知用户调解员发布调解笔录
   */
  USER_NOTIFY_PUBLISH_RECORD,
  /**
   * 通知单位调解员发布调解笔录
   */
  MONAD_NOTIFY_PUBLISH_RECORD,
  /**
   * 通知代理人调解员发布调解笔录
   */
  AGENT_NOTIFY_PUBLISH_RECORD,
  /**
   * 通知用户调解员发布无异议
   */
  USER_NOTIFY_PUBLISH_NO_DISSENT,
  /**
   * 通知单位调解员发布无异议
   */
  MONAD_NOTIFY_PUBLISH_NO_DISSENT,
  /**
   * 通知代理人调解员发布无异议
   */
  AGENT_NOTIFY_PUBLISH_NO_DISSENT,
  /**
   * 通知用户调解员发布无争议
   */
  USER_NOTIFY_PUBLISH_UNDISPUTED,
  /**
   * 通知单位调解员发布无争议
   */
  MONAD_NOTIFY_PUBLISH_UNDISPUTED,
  /**
   * 通知代理人调解员发布无争议
   */
  AGENT_NOTIFY_PUBLISH_UNDISPUTED,
  /**
   * 引调案件通知机构管理员
   */
  YT_NOTIFY_ADMIN,
  /**
   * 通知当事人共道注册
   */
  PARTY_GONGDAO_REGISTER,
  /**
   * 邮箱激活
   */
  EMAIL_ACTIVE;
}
