package com.beiming.odr.referee.enums;

/**
 * @Description: 用户类型枚举
 * @Author: caiwei
 * @Date: Created 2018-06-21
 */
public enum UserTypeEnum {
  NATURAL_PERSON("自然人", "15_000004-1", "09_01001-1"), JURIDICAL_PERSON("法人",
      "15_000004-2", "09_01001-2"), UNINCORPORATED_ORGANIZATION("非法人组织", "15_000004-3", "09_01001-3");

  private String name;
  private String tdhCode;
  private String tdhOldCode;

  UserTypeEnum(String name, String tdhCode, String tdhOldCode) {
    this.name = name;
    this.tdhCode = tdhCode;
    this.tdhOldCode = tdhOldCode;
  }

  public String getName() {
    return name;
  }

  public String getTdhCode() {
    return tdhCode;
  }

  public void setTdhCode(String tdhCode) {
    this.tdhCode = tdhCode;
  }

  public String getTdhOldCode() {
    return tdhOldCode;
  }

  public void setTdhOldCode(String tdhOldCode) {
    this.tdhOldCode = tdhOldCode;
  }

  public static UserTypeEnum convert(String value) {
    switch (value) {
      case "15_000004-1":
      case "09_01001-1":
        return NATURAL_PERSON;
      case "15_000004-2":
      case "09_01001-2":
        return JURIDICAL_PERSON;
      case "15_000004-3":
      case "09_01001-3":
        return UNINCORPORATED_ORGANIZATION;
      default:
        return null;
    }
  }
}
