package com.beiming.odr.referee.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.util.UriUtils;

/**
 * @Auther: Administrator
 * @Date: 2019/1/31/031 11:10
 * @Description:
 */
@Slf4j
public class DownLoadUtil {

  public  static byte[] doGetRequestForFile(String urlStr) throws IOException {

    InputStream is = null;
    ByteArrayOutputStream os = null;
    byte[] buff = new byte[1024];
    int len = 0;
    try {
      URL url = new URL(UriUtils.encodePath(urlStr, "UTF-8"));
      HttpURLConnection conn = (HttpURLConnection) url.openConnection();
      conn.setRequestProperty("Content-Type", "plain/text;charset=" + "UTF-8");
      conn.setRequestProperty("charset", "UTF-8");
      conn.setDoInput(true);
      conn.setDoOutput(true);
      conn.setRequestMethod("GET");
      conn.connect();
      is = conn.getInputStream();
      os = new ByteArrayOutputStream();
      while ((len = is.read(buff)) != -1) {
        os.write(buff, 0, len);
      }
      return os.toByteArray();
    } catch (IOException e) {
      log.error("发起请求出现异常:", e);
      return null;
    } finally {
      if (is != null) {
        is.close();

      }
      if (os != null) {
        os.close();
      }
    }
  }


}
