/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.referee.enums;

public enum DocumentTypeEnum {
    MEDIATION_BOOK("\u8c03\u89e3\u534f\u8bae\u4e66"),
    COMMITMENT_BOOK("\u627f\u8bfa\u4e66"),
    NO_DISSENT_MEDIATION_SCHEME("\u65e0\u5f02\u8bae\u8c03\u89e3\u65b9\u6848"),
    UNDISPUTED_FACT("\u65e0\u4e89\u8bae\u4e8b\u5b9e\u786e\u8ba4\u534f\u8bae"),
    MEDIATION_RECORD("\u8c03\u89e3\u7b14\u5f55"),
    INQUIRE_RECORD("\u8c03\u67e5\u7b14\u5f55"),
    DISSENT_RECORD("\u5f02\u8bae\u4e66"),
    JUDICIAL_CONFIRM_APPLY_BOOK("\u7533\u8bf7\u53f8\u6cd5\u786e\u8ba4\u4e66"),
    FINAL_MEDIATION_REPORT("\u7ec8\u7ed3\u8c03\u89e3\u62a5\u544a"),
    MEDIATION_APPLY_BOOK("\u8bf7\u6c42\u6cd5\u9662\u51fa\u5177\u8c03\u89e3\u4e66"),
    RECONCILIATION_AGREEMENT("\u8c03\u89e3\u4e66"),
    WITHDRAW_CASE("\u64a4\u56de\u7acb\u6848"),
    JUDICIAL_CONFIRM_BOOK("\u53f8\u6cd5\u786e\u8ba4\u4e66"),
    CLOSE_CASE_BOOK("\u8bc9\u4e2d\u7ed3\u6848\u6587\u4e66");

    private String name;

    private DocumentTypeEnum(String name) {
        this.name = name;
    }

    public static boolean noMsgDoc(String docType) {
        return !MEDIATION_RECORD.name().equals(docType) && !MEDIATION_BOOK.name().equals(docType) && !UNDISPUTED_FACT.name().equals(docType) && !NO_DISSENT_MEDIATION_SCHEME.name().equals(docType);
    }

    public String getName() {
        return this.name;
    }

    public static Boolean isRecord(String documentType) {
        return MEDIATION_RECORD.name().equalsIgnoreCase(documentType) || INQUIRE_RECORD.name().equalsIgnoreCase(documentType);
    }
}

