package com.beiming.odr.user.api.dto.requestdto;

import com.beiming.odr.user.api.common.constants.UserConst;
import java.io.Serializable;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import lombok.Data;

/**
 * 普通用户注册
 */
@Data
public class CommonUserRegisterReqDTO implements Serializable {

  /**
   * 手机号
   */
//  @NotBlank(message = "{user.phoneNotBlank}")
  @Pattern(regexp = UserConst.REGEX_MOBILE_EXACT, message = "{user.phoneFormatError}")
  private String mobilePhone;
  /**
   * 邮箱号
   */
//  @NotBlank(message = "{user.emailNotBlank}") //邮箱不能为空
  @Pattern(regexp = UserConst.REGEX_EMAIL, message = "{user.emailFormatterError}")
  private String email;
  /**
   * 密码
   */
  @NotBlank(message = "{user.passwordNotBlank}")
  @Pattern(regexp = UserConst.REGEX_PASSWORD, message = "{user.passwordFormatError}")
  private String password;

  private String idCard;

  private Boolean qrCodeFlag; //true是扫码登录

  private String name;

  private String registerType; //注册类型
}
