package com.beiming.odr.user.api.dto.requestdto;

import java.io.Serializable;
import javax.validation.constraints.Pattern;
import com.beiming.framework.page.PageQuery;
import com.beiming.odr.user.api.common.constants.UserConst;
import lombok.Data;

/**
 * 普通用户列表参数
 */

@Data
public class OrdinaryUserListReqDTO extends PageQuery implements Serializable {

  /**
   * 姓名
   */
  private String userName;


  /**
   * 手机号
   */
  private String mobilePhone;

  /**
   * 身份证
   */
  @Pattern(regexp = UserConst.REGEX_ID_CARD, message = "{user.idCardNotIncorrect}")
  private String idCard;

  /**
   * 人员类型
   */
  private String personType;

  /**
   * 业务人员类型
   */
  private String businessPeopleType;

  /**
   * 角色类型
   */
  private String roleType;

}
