package com.beiming.odr.user.api.dto.requestdto;

import java.io.Serializable;
import javax.validation.constraints.Pattern;
import lombok.Data;
import org.hibernate.validator.constraints.NotBlank;
import com.beiming.odr.user.api.common.constants.UserConst;
import com.beiming.odr.user.api.common.enums.StatusEnum;
import com.beiming.odr.user.api.page.QueryPageParam;

/**
 * 用户注册
 */
@Data
public class UserReqDTO extends QueryPageParam implements Serializable {

  /**
   * 自增
   */
  private Long id;

  /**
   * 姓名
   */
  @NotBlank(message = "{user.nameNotBlank}")
  private String userName;



  /**
   * 手机号
   */
  @Pattern(regexp = UserConst.REGEX_MOBILE_EXACT, message = "{user.phoneFormatError}")
  private String mobilePhone;

  /**
   * 身份证
   */
  @Pattern(regexp = UserConst.REGEX_ID_CARD, message = "{user.idCardNotIncorrect}")
  private String idCard;

  /**
   * 密码
   */
  private String password;

  /**
   * 状态 0 正常 1 删除
   */
  private StatusEnum status;

  /**
   * 备注
   */
  private String remark;

  /**
   * 创建人
   */
  private String createUser;

  /**
   * 修改人
   */
  private String updateUser;

  /**
   * 角色类型
   */
  private String roleCode;
}
