package com.beiming.odr.user.api;

import java.util.ArrayList;
import javax.validation.Valid;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.user.api.dto.requestdto.AddCapacityTemplateReqDTO;
import com.beiming.odr.user.api.dto.requestdto.CapacityAssessmentListReqDTO;
import com.beiming.odr.user.api.dto.requestdto.CapacityAssessmentSingleReqDTO;
import com.beiming.odr.user.api.dto.requestdto.CapacityTemplateListReqDTO;
import com.beiming.odr.user.api.dto.requestdto.CapacityTemplateSingleReqDTO;
import com.beiming.odr.user.api.dto.requestdto.DelCapacityTemplateReqDTO;
import com.beiming.odr.user.api.dto.requestdto.ModCapacityTemplateReqDTO;
import com.beiming.odr.user.api.dto.requestdto.WorkerCenterReqDTO;
import com.beiming.odr.user.api.dto.responsedto.CapacityAssessmentResDTO;
import com.beiming.odr.user.api.dto.responsedto.CapacityTemplateResDTO;
import com.beiming.odr.user.api.dto.responsedto.WorkerCenterResDTO;

/**
 * 能力评估接口
 * @author ljf
 *
 */
public interface CapacityAssessmentApi {

  /**
   * 分页查询模板
   * @param arg0
   * @return
   */
  DubboResult<PageInfo<CapacityTemplateResDTO>> selCapacityTemplatePageList(@Valid CapacityTemplateListReqDTO arg0);
  /**
   * 查询单个模板
   * @param arg0
   * @return
   */
  DubboResult<CapacityTemplateResDTO> selTemplateSingle(@Valid CapacityTemplateSingleReqDTO arg0);
  /**
   * 分页查询能力评估结果
   * @param arg0
   * @return
   */
  DubboResult<PageInfo<CapacityAssessmentResDTO>> selCapacityAssessmentPageList(@Valid CapacityAssessmentListReqDTO arg0);
  /**
   * 查询单个能力评估结果
   * @param arg0
   * @return
   */
  DubboResult<CapacityAssessmentResDTO> selCapacityAssessmentSingle(@Valid CapacityAssessmentSingleReqDTO arg0);
  /**
   * 新增模板（
   * @param arg0
   * @return
   */
  DubboResult addCapacityTemplate(@Valid AddCapacityTemplateReqDTO arg0);
  /**
   * 修改模板（被引用过的模板不能修改）
   * @param arg0
   * @return
   */
  DubboResult modCapacityTemplate(@Valid ModCapacityTemplateReqDTO arg0);
  /**
   * 删除模板（逻辑）（被引用过的模板不能删除）
   * @param arg0
   * @return
   */
  DubboResult delCapacityTemplate(@Valid DelCapacityTemplateReqDTO arg0);
  
  /**
   * 个人中心查询我的能力评估
   * 逻辑判断userId是否是管理员
   * @param arg0 userId不能为空
   * @return
   */
  DubboResult<WorkerCenterResDTO> getWorkerCenterInfo(@Valid WorkerCenterReqDTO arg0);
  /**
   * 导出数据
   * @param arg0
   * @return
   */
  DubboResult<ArrayList<CapacityAssessmentResDTO>> exportCapacityResult(@Valid CapacityAssessmentListReqDTO arg0);
}
