package com.beiming.odr.user.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.user.api.common.enums.PersonTypeEnum;
import com.beiming.odr.user.api.common.enums.UserLoginTypeEnum;
import com.beiming.odr.user.api.dto.requestdto.CaseUserRegisterReqDTO;
import com.beiming.odr.user.api.dto.requestdto.CommonIdReqDTO;
import com.beiming.odr.user.api.dto.requestdto.CommonUserRegisterReqDTO;
import com.beiming.odr.user.api.dto.requestdto.CommonUserResetPasswordReqDTO;
import com.beiming.odr.user.api.dto.requestdto.CommonUserUpdatePasswordReqDTO;
import com.beiming.odr.user.api.dto.requestdto.CommonUserUpdateReqDTO;
import com.beiming.odr.user.api.dto.requestdto.RealNameAuthenticationReqDTO;
import com.beiming.odr.user.api.dto.requestdto.SelMediatorSingleInfoReqDTO;
import com.beiming.odr.user.api.dto.requestdto.ServicePersonListReqDTO;
import com.beiming.odr.user.api.dto.responsedto.CaseUserRegisterResDTO;
import com.beiming.odr.user.api.dto.responsedto.CommonUserSearchResDTO;
import com.beiming.odr.user.api.dto.responsedto.LoginInfoResDTO;
import com.beiming.odr.user.api.dto.responsedto.MediatorSingleInfoResDTO;
import com.beiming.odr.user.api.dto.responsedto.ServicePersonListResDTO;
import com.beiming.odr.user.api.dto.responsedto.UserRoleInfoListResDTO;
import java.util.ArrayList;
import javax.validation.Valid;

@Valid
public interface UserServiceApi {

  /**
   * 新增普通用户
   */
  DubboResult<LoginInfoResDTO> insertCommonUser(
      @Valid CommonUserRegisterReqDTO commonUserRegisterReqDTO);

  /**
   * 用户登录 -可以通过mobile也可以通过loginName
   *
   * @param mobile
   * @param password
   * @param loginName
   * @param loginType
   */
  DubboResult<LoginInfoResDTO> userLogin(String mobile, String password, String loginName,
      UserLoginTypeEnum loginType);


  DubboResult<LoginInfoResDTO> getUserLoginInfo(String userId);

  DubboResult<String> getUserDetialSex(Long userId);

  /**
   * 更新普通用户
   */
  DubboResult updateCommonUser(CommonUserUpdateReqDTO commonUserUpdateReqDTO);

  /**
   * 重置登录密码
   *
   * @param commonUserResetPasswordReqDTO
   */
  DubboResult resetUserPassword(@Valid CommonUserResetPasswordReqDTO commonUserResetPasswordReqDTO);

  /**
   * 人脸识别通过-设置
   *
   * @param UserBasicsId 用户ID
   */
  DubboResult setFacialVerify(Long userBasicsId);


  /** 实名认证-设置 */
  DubboResult setRealNameAuthentication(Long userId,
      RealNameAuthenticationReqDTO realNameAuthenticationReqDTO);

  /** 查询普通用户的信息 */
  DubboResult<CommonUserSearchResDTO> searchCommonUser(CommonIdReqDTO commonIdReqDTO);

  /**
   * 查询服务人员列表分页
   *
   * @param servicePersonListReqDTO
   * @return
   */
  DubboResult<PageInfo<ServicePersonListResDTO>> getServicePersonListPage(
      ServicePersonListReqDTO servicePersonListReqDTO);

  /**
   * 案件用户注册接口
   */
  DubboResult<CaseUserRegisterResDTO> caseUserregister(
      @Valid CaseUserRegisterReqDTO caseUserRegisterReqDTO);

  /**
   * 修改密码
   *
   * @param commonUserUpdatePasswordReqDTO
   */
  DubboResult updatePassword(CommonUserUpdatePasswordReqDTO commonUserUpdatePasswordReqDTO);

  /**
   * 修改手机号码
   */
  DubboResult updateMobilePhone(Long userId, String mobilePhone);


  /**
   * 用过手机号码判断用户是否存在
   *
   * @param mobile 手机号码
   * @param personTypeEnum 人员类型
   * @return true 存在 false 不存在
   */
  DubboResult<Boolean> checkUserByMobile(String mobile, PersonTypeEnum personTypeEnum);

  /**
   * 获取用户角色信息
   *
   * @param userId 用户id
   * @param orgId 机构id
   */
  DubboResult<UserRoleInfoListResDTO> getRoleInfoByUserId(Long userId);


  /**
   * 获取内部测试用户userId
   * @return
   */
  DubboResult<String> getInternalTestUserId();

  /**
   * 保存内部测试用户userId,id以逗号隔开
   * @return
   */
  DubboResult saveInternalTestUserId(String userId);

  /**
   * 获取内部测试机构id
   * @return
   */
  DubboResult<String> getInternalTestOrgId();

  /**
   * 保存内部测试机构id,id以逗号隔开
   * @return
   */
  DubboResult saveInternalTestOrgId(String orgId);

  /**
   * 校验姓名和身份证是否匹配
   *
   * @return
   */
  DubboResult<Boolean> checkRealNameAuthentication(RealNameAuthenticationReqDTO req);
  /**
   * 根据区域代码查询下面的所有调解员
   * 只需要传区域代码
   * @param arg0
   * @return
   */
  DubboResult<ArrayList<MediatorSingleInfoResDTO>> selMediatorSingleInfoListByAreaCode(@Valid SelMediatorSingleInfoReqDTO arg0);
  /**
   * <pre>
   * 根据机构号查询该机构下的所有调解员
   * 只需要传机构代码
   * @param arg0
   * @return
   */
  DubboResult<ArrayList<MediatorSingleInfoResDTO>> selMediatorSingleInfoListWithOrgManage(@Valid SelMediatorSingleInfoReqDTO arg0);

  /**
   * <pre>
   * 腾讯实名认证
   * @param DubboResult
   * @return
   */

  DubboResult checkUserByLoginName(String loginName, PersonTypeEnum type);
}
