package com.beiming.odr.user.api.dto;

import java.io.Serializable;
import com.beiming.odr.user.api.common.enums.BusinesPersonTypeEnum;
import java.util.Date;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
public class UserInfoDTO implements Serializable {

  public UserInfoDTO(Long userId, String userName) {
    this.userId = userId;
    this.userName = userName;
  }

  public UserInfoDTO(Long userId, String loginName, String mobilePhone, String idCard,
      String userName, String headPortraitUrl, Boolean isRealName, Boolean isFacialVerify,
      String email, String personType, String sex, String businessPeopleType) {
    this.userId = userId;
    this.loginName = loginName;
    this.mobilePhone = mobilePhone;
    this.idCard = idCard;
    this.userName = userName;
    this.headPortraitUrl = headPortraitUrl;
    this.isRealName = isRealName;
    this.isFacialVerify = isFacialVerify;
    this.email = email;
    this.personType = personType;
    this.sex = sex;
    if (BusinesPersonTypeEnum.PETITION_LETTER_AGENT.toString().equals(businessPeopleType)) {
      this.petitionLetterAgentFlag = true;
    } else {
      this.petitionLetterAgentFlag = false;
    }
  }

  /**
   * 人员类型
   */
  private String personType;
  /** 用户id */

  private Long userId;
  /**
   * 用户登录名
   */
  private String loginName;

  /**
   * 手机号
   */
  private String mobilePhone;

  /**
   * 身份证
   */
  private String idCard;

  private String cardType;
  /**
   * 民族
   */
  private String nation;

  /**
   * 国籍
   */
  private String nationality;
  /**
   * 用户姓名
   */
  private String userName;

  /**
   * 头像
   */
  private String headPortraitUrl;

  /**
   * 是否实名
   */
  private Boolean isRealName;

  /**
   * 是否完成人脸识别
   */
  private Boolean isFacialVerify;

  /**
   * 邮箱
   */
  private String email;

  /**
   * 服务人员在线繁忙状态
   */
  private String servicePersonStatus;

  /**
   * 性别
   */
  private String sex;

  /**
   * 是否是信访用户
   */
  private Boolean petitionLetterAgentFlag;

  /**
   * 所属的角色类型
   */
  private String roleType;
  /**
   * 重置密码次数
   */
  private Integer resetPwdNum;

  /**
   * 重置密码时间
   */
  private Date resetPwdTime;

  /** 当前居住地址 */
  private UserAddressInfoDTO currentAddress;
  /** 户籍地址 */
  private UserAddressInfoDTO permanentAddress;
  /** 详细地址 */
  private String detailAddress;

  /** 所属机构id */
  private Long orgId;
  /** 所属机构 */
  private String organizationName;

}
