package com.beiming.odr.user.api.dto.requestdto;

import java.io.Serializable;
import java.util.Date;
import javax.validation.constraints.NotNull;
import com.beiming.odr.user.api.common.enums.StatusEnum;
import com.beiming.odr.user.api.page.QueryPageParam;
import lombok.Data;

/**
 * 角色和权限对应关系 前段请求类
 */
@Data
public class AuthRoleRelationReqDTO extends QueryPageParam implements Serializable {
  /**
   * 角色id
   */
  @NotNull(message = "{user.phoneFormatError}")
  private String roleCode;

  /**
   * 菜单id
   */
  private String listMenuId;

  /**
   * 状态 0 正常 1 删除
   */
  private StatusEnum status;

  /**
   * 备注
   */
  private String remark;

  /**
   * 创建人
   */
  private String createUser;

  /**
   * 创建时间
   */
  private Date createTime;

  /**
   * 修改人
   */
  private String updateUser;

  /**
   * 修改时间
   */
  private Date updateTime;

  /**
   * 版本号
   */
  private Integer version;

}
