/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.user.api.dto.responsedto;

import com.alibaba.dubbo.common.utils.CollectionUtils;
import com.beiming.odr.user.api.common.enums.RoleTypeEnum;
import com.beiming.odr.user.api.dto.UserInfoDTO;
import com.beiming.odr.user.api.dto.UserMenuInfoDTO;
import com.beiming.odr.user.api.dto.UserRoleInfoDTO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class LoginInfoResDTO
implements Serializable {
    private static final long serialVersionUID = 1939993907517003148L;
    private UserInfoDTO userInfo;
    private List<UserRoleInfoDTO> userRoles;
    private List<UserMenuInfoDTO> userMenuInfo;
    private String resetPwdTip;

    public LoginInfoResDTO() {
    }

    public LoginInfoResDTO(UserInfoDTO userInfo, List<UserRoleInfoDTO> userRoles, List<UserMenuInfoDTO> userMenuInfo) {
        if (userInfo != null) {
            this.userInfo = userInfo;
            this.userInfo.setIsRealName(userInfo.getIsRealName() == null ? false : userInfo.getIsRealName());
            this.userInfo.setIsFacialVerify(userInfo.getIsFacialVerify() == null ? false : userInfo.getIsFacialVerify());
            if (!CollectionUtils.isEmpty(userMenuInfo)) {
                this.userMenuInfo = new ArrayList<UserMenuInfoDTO>();
                this.userMenuInfo.addAll(userMenuInfo);
            }
            if (!CollectionUtils.isEmpty(userRoles)) {
                userRoles = this.sortRoles(userRoles);
                this.userRoles = new ArrayList<UserRoleInfoDTO>();
                this.userRoles.addAll(userRoles);
            }
        }
    }

    private List<UserRoleInfoDTO> sortRoles(List<UserRoleInfoDTO> userRoles) {
        return userRoles.stream().sorted((o1, o2) -> {
            Integer sort1 = RoleTypeEnum.getSortByEnumName(o1.getRoleType());
            Integer sort2 = RoleTypeEnum.getSortByEnumName(o2.getRoleType());
            return sort1.compareTo(sort2);
        }).collect(Collectors.toList());
    }

    public UserInfoDTO getUserInfo() {
        return this.userInfo;
    }

    public List<UserRoleInfoDTO> getUserRoles() {
        return this.userRoles;
    }

    public List<UserMenuInfoDTO> getUserMenuInfo() {
        return this.userMenuInfo;
    }

    public String getResetPwdTip() {
        return this.resetPwdTip;
    }

    public void setUserInfo(UserInfoDTO userInfo) {
        this.userInfo = userInfo;
    }

    public void setUserRoles(List<UserRoleInfoDTO> userRoles) {
        this.userRoles = userRoles;
    }

    public void setUserMenuInfo(List<UserMenuInfoDTO> userMenuInfo) {
        this.userMenuInfo = userMenuInfo;
    }

    public void setResetPwdTip(String resetPwdTip) {
        this.resetPwdTip = resetPwdTip;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LoginInfoResDTO)) {
            return false;
        }
        LoginInfoResDTO other = (LoginInfoResDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UserInfoDTO this$userInfo = this.getUserInfo();
        UserInfoDTO other$userInfo = other.getUserInfo();
        if (this$userInfo == null ? other$userInfo != null : !((Object)this$userInfo).equals(other$userInfo)) {
            return false;
        }
        List<UserRoleInfoDTO> this$userRoles = this.getUserRoles();
        List<UserRoleInfoDTO> other$userRoles = other.getUserRoles();
        if (this$userRoles == null ? other$userRoles != null : !((Object)this$userRoles).equals(other$userRoles)) {
            return false;
        }
        List<UserMenuInfoDTO> this$userMenuInfo = this.getUserMenuInfo();
        List<UserMenuInfoDTO> other$userMenuInfo = other.getUserMenuInfo();
        if (this$userMenuInfo == null ? other$userMenuInfo != null : !((Object)this$userMenuInfo).equals(other$userMenuInfo)) {
            return false;
        }
        String this$resetPwdTip = this.getResetPwdTip();
        String other$resetPwdTip = other.getResetPwdTip();
        return !(this$resetPwdTip == null ? other$resetPwdTip != null : !this$resetPwdTip.equals(other$resetPwdTip));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LoginInfoResDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UserInfoDTO $userInfo = this.getUserInfo();
        result = result * 59 + ($userInfo == null ? 43 : ((Object)$userInfo).hashCode());
        List<UserRoleInfoDTO> $userRoles = this.getUserRoles();
        result = result * 59 + ($userRoles == null ? 43 : ((Object)$userRoles).hashCode());
        List<UserMenuInfoDTO> $userMenuInfo = this.getUserMenuInfo();
        result = result * 59 + ($userMenuInfo == null ? 43 : ((Object)$userMenuInfo).hashCode());
        String $resetPwdTip = this.getResetPwdTip();
        result = result * 59 + ($resetPwdTip == null ? 43 : $resetPwdTip.hashCode());
        return result;
    }

    public String toString() {
        return "LoginInfoResDTO(userInfo=" + this.getUserInfo() + ", userRoles=" + this.getUserRoles() + ", userMenuInfo=" + this.getUserMenuInfo() + ", resetPwdTip=" + this.getResetPwdTip() + ")";
    }
}

