package com.beiming.odr.user.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.user.api.dto.requestdto.*;
import com.beiming.odr.user.api.dto.responsedto.BackstageOrganizationResDTO;
import com.beiming.odr.user.api.dto.responsedto.BackstageUserInfoResDTO;

/**
 * 机构相关接口
 *
 * @author fanheshui
 */
public interface BackstageOrganizationServiceApi {
  /**
   * 新增机构信息
   *
   * @param BackstageOrganizationAddReqDTO
   */
  public DubboResult addBackstageOrganization(BackstageOrganizationAddReqDTO req);

  /**
   * 编辑机构信息
   *
   * @param BackstageOrganizationUpdateReqDTO
   */
  public DubboResult updateBackstageOrganization(BackstageOrganizationUpdateReqDTO req);


  /**
   * 查询机构信息
   *
   * @param BackstageOrganizationSearchReqDTO
   */
  public DubboResult<BackstageOrganizationResDTO> searchBackstageOrganization(
      BackstageOrganizationSearchReqDTO req);

  /**
   * 查询机构信息 列表
   *
   * @param BackstageOrganizationListReqDTO
   */
  public DubboResult<PageInfo<BackstageOrganizationResDTO>> listBackstageOrganization(
      BackstageOrganizationListReqDTO req);

  public DubboResult editOrder(BackstageOrganizationEditOrderReqDTO req);

  /**
   * 工作人员列表(对接国商) 生产环境dubbo有密码
   */
  DubboResult<PageInfo<BackstageUserInfoResDTO>> listBackstageUser(BackstageUserListReqDTO backstageUserListReqDTO);
}

