package com.beiming.odr.user.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.user.api.dto.requestdto.*;
import com.beiming.odr.user.api.dto.responsedto.SearchServicePersonResDTO;
import com.beiming.odr.user.api.dto.responsedto.SerchServicePersonGrantAuthInfoResDTO;
import com.beiming.odr.user.api.dto.responsedto.UserEvaluateGradeCountListResDTO;

import javax.validation.Valid;

/**
 * 服务人员相关接口
 *
 * @author
 */
@Valid
public interface ServicePersonServiceApi {

  /**
   * 查询用户评价数和星星数（多用户）
   * @param userEvaluateGradeCountListReqDTO
   * @return
   */
  public DubboResult<UserEvaluateGradeCountListResDTO> getUserEvaluateGradeCountListToGs(UserEvaluateGradeCountListReqDTO userEvaluateGradeCountListReqDTO);

  /**
   * 机构管理员-添加服务人员
   */
  public DubboResult addServicePerson(AddServicePersonReqDTO addServicePersonReqDTO);

  /**
   * 查询服务人员详细信息
   */
  public DubboResult<SearchServicePersonResDTO> searchServicePerson(
      SearchServicePersonReqDTO searchServicePersonReqDTO);

  /**
   * 机构管理员-编辑服务人员
   */
  DubboResult updateServicePerson(AddServicePersonReqDTO addServicePersonReqDTO);

  /**
   * 查询服务人员授权信息
   */
  DubboResult<SerchServicePersonGrantAuthInfoResDTO> serchServicePersonGrantAuthInfo(Long userId);

  /**
   * 查询服务人员详细信息-通过手机号码
   */
  DubboResult<SearchServicePersonResDTO> searchServicePersonByMobile(
      SearchServicePersonReqByMobileDTO request);

  /**
   * 机构管理员-更新服务人员权限
   */
  DubboResult updateServicePersonRole(
      @Valid ServicePersonUpdateRoleReqDTO servicePersonUpdateRoleReqDTO);

}
