package com.beiming.odr.user.api.dto.requestdto;

import java.io.Serializable;
import javax.validation.constraints.NotBlank;
import com.alibaba.fastjson.JSONObject;
import lombok.Data;

/**
 * 普通用户注册请求接口
 */
@Data
public class CommonUserUpdateReqDTO implements Serializable {

  /**
   * userId
   */
  private Long userId;
  /**
   * 身份证
   */
  private String idCard;

  /**
   * 用户姓名
   */
  private String userName;

  /**
   * 国籍
   */
  private String nationality;

  /**
   * 证件类型
   */
  private String cardType;

  /**
   * 性别
   */
  @NotBlank(message = "{user.sexNotBlank}")
  private String sex;

  /**
   * 生日
   */
  private String birthday;


  /*
   * [{provinceCode：, provinceName：, cityCode：, cityName：, areaCode：, areaName：, streetCode：,
   * streetName：, communitCode：, communityName：, detailedAddress：},{....}]
   */
  /** 当前居住地址 */
  private JSONObject currentAddress;
  /** 户籍地址 */
  private JSONObject permanentAddress;
  /** 头像 */
  private String portraitUrl;


}
