package com.beiming.odr.user.api.dto.requestdto;

import java.io.Serializable;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import lombok.Data;
import com.beiming.odr.user.api.common.constants.UserConst;

/**
 * 用户账号登录请求
 */
@Data
public class UserAccountLoginReqDTO implements Serializable {

  /**
   * 手机号
   */
  @NotBlank(message = "{user.nameNotBlank}")
  private String loginName;

  /**
   * 密码
   */
  @Pattern(regexp = UserConst.REGEX_PASSWORD, message = "{user.passwordFormatError}")
  private String password;
}
