package com.beiming.odr.user.api;


import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.user.api.dto.DictionaryInfoDTO;
import com.beiming.odr.user.api.dto.requestdto.DictionaryReqDTO;
import com.beiming.odr.user.api.dto.responsedto.DictCaseReasonDTO;
import com.beiming.odr.user.api.dto.responsedto.DictionaryResDTO;
import java.util.ArrayList;
import java.util.List;

/**
 * 字典
 * 
 * @author fhs
 * @date 2018年6月13日
 */
public interface DictionaryServiceApi {

  /**
   * 根据parentCode 查询字典项
   * 
   * @param parentCode
   * @param code
   */
  public DubboResult<DictionaryResDTO> searchDictionaryInfo(DictionaryReqDTO dictionaryReqDTO);


  /** 新增字典信息 */
  public DubboResult insertDictionary(DictionaryReqDTO dictionaryReqDTO);

  /*** 查询字典信息 */
  public DubboResult<DictionaryInfoDTO> searchDictionary(Long dictionaryId);

  /** 字典列表 */
  public DubboResult<PageInfo<DictionaryInfoDTO>> listDictionary(DictionaryReqDTO dictionaryReqDTO);

  /** 更新字典 */
  public DubboResult updateDictionary(DictionaryReqDTO dictionaryReqDTO);

  /** 删除字典 */
  public DubboResult deleteDictionary(Long dictionaryId);
  
  /** 通过父级代码数组查询字典信息 */
  public DubboResult<DictionaryResDTO> getDictionaryByParentCode(List<String> parentCodes);

  DubboResult<String> getValueByCode(String code);

  /**
   * 查找案由
   * @return
   */
  DubboResult<ArrayList<DictCaseReasonDTO>> selectNode(String language);

  /**
   * 根据系统当前环境翻译
   */
  DubboResult<String> translateCaseReason(String disTypeCode);

  /**
   * 可随意翻译纠纷类型的三语
   */
  DubboResult<String> translateCaseReason(String disTypeCode, String language);
}
