package com.beiming.odr.user.api.common.enums;

/**
 * @Description:状态枚举类型
 * @Author: heshui-fan
 * @Date: Created 2018/4/28
 */
public enum RoleTypeEnum {

  COMMON("普通用户", 10), CONSELOR("咨询师", 8), MEDIATOR("调解员", 5), JUDGE("办案法官", 6),
  CUSTOMER_SERVICE("客服", 7), ORG_MANAGE("机构管理员", 3), AREA_MANAGE("行政区域管理员", 2),
  DISPUTE_REGISTRAR("纠纷登记员", 4), SUPER_ADMIN("超级管理员", 1), PUBLIC_LAWYER("公益律师", 9);

  private String name;

  private Integer sort;

  public static Integer getSortByEnumName(String name) {
    RoleTypeEnum[] values = RoleTypeEnum.values();
    for (RoleTypeEnum value : values) {
      if (value.toString().equalsIgnoreCase(name)) {
        return value.sort;
      }
    }
    return 1;
  }

  RoleTypeEnum(String name, Integer sort) {
    this.name = name;
    this.sort = sort;
  }

  public String getName() {
    return name;
  }
}
