package com.beiming.odr.user.api.dto.requestdto;

import java.io.Serializable;
import lombok.Data;
import com.beiming.framework.page.PageQuery;

@Data
public class ServicePersonListReqDTO extends PageQuery implements Serializable {
  
  /**
   * 人员名称
   */
  private String userName;
  
  /**
   * 机构id
   */
  private Long orgId;

  /**
   * 擅长领域
   */
  private String ability;
  
  /**
   * 调解方式
   */
  private String mediateCode;
  
  /**
   * 人员类型（调解员、咨询师、法官）
   */
  private String roleType;
  
  /**
   * 区域代码
   */
  private String areaCode;
  
  /**
   * 服务区域代码前两位（匹配省）
   */
  private String serviceAreaCodeTwo;
  
  /**
   * 服务区域代码前四位（匹配市）
   */
  private String serviceAreaCodeFour;
  
  /**
   * 服务区域代码前六位（匹配区）
   */
  private String serviceAreaCodeSix;

  /**
   * 服务区域代码前九位（匹配街道）
   */
  private String serviceAreaCodeNine;
  /**
   * 服务区域代码十二位（匹配社区）
   */
  private String serviceAreaCodeTwelve;
  
  /**
   * 当前登录用户id
   */
  private String currentUserId;

  /**
   * 备注
   */
  private String remark;
  
  /**
   * 关键字（用户名称或擅长领域）
   */
  private String keywords;
  
}
