package com.beiming.odr.user.api.dto.responsedto;

import com.alibaba.dubbo.common.utils.CollectionUtils;
import com.beiming.odr.user.api.common.enums.RoleTypeEnum;
import com.beiming.odr.user.api.dto.UserInfoDTO;
import com.beiming.odr.user.api.dto.UserMenuInfoDTO;
import com.beiming.odr.user.api.dto.UserRoleInfoDTO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Data;

@Data
public class LoginInfoResDTO implements Serializable {

  private static final long serialVersionUID = 1939993907517003148L;

  private UserInfoDTO userInfo;
  private List<UserRoleInfoDTO> userRoles;
  private List<UserMenuInfoDTO> userMenuInfo;
  private String resetPwdTip; //要求修改密码的提示语

  public LoginInfoResDTO() {

  }

  public LoginInfoResDTO(UserInfoDTO userInfo, List<UserRoleInfoDTO> userRoles,
      List<UserMenuInfoDTO> userMenuInfo) {
    if (userInfo != null) {
      this.userInfo = userInfo;
      this.userInfo
          .setIsRealName(userInfo.getIsRealName() == null ? false : userInfo.getIsRealName());
      this.userInfo.setIsFacialVerify(
          userInfo.getIsFacialVerify() == null ? false : userInfo.getIsFacialVerify());
      if (!CollectionUtils.isEmpty(userMenuInfo)) {
        this.userMenuInfo = new ArrayList<>();
        this.userMenuInfo.addAll(userMenuInfo);
      }
      if (!CollectionUtils.isEmpty(userRoles)) {
        userRoles = sortRoles(userRoles);
        this.userRoles = new ArrayList<>();
        this.userRoles.addAll(userRoles);
      }
    }
  }

  private List<UserRoleInfoDTO> sortRoles(List<UserRoleInfoDTO> userRoles) {
    return userRoles.stream().sorted((o1, o2) -> {
      Integer sort1 = RoleTypeEnum.getSortByEnumName(o1.getRoleType());
      Integer sort2 = RoleTypeEnum.getSortByEnumName(o2.getRoleType());
      return sort1.compareTo(sort2);
    }).collect(Collectors.toList());
  }
}
