package com.beiming.odr.consultancy.dto.requestdto;

import com.beiming.odr.consultancy.api.ValidationMessage;
import java.io.Serializable;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * Created by chenjt on 2018/6/27
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class DisputeLawCaseReqDTO implements Serializable {


  private static final long serialVersionUID = -3223177834763421930L;

  public DisputeLawCaseReqDTO(Long lawCaseId, Long disputeId) {
    this.lawCaseId = lawCaseId;
    this.disputeId = disputeId;
  }
  /**
   * 纠纷id
   */
  @NotNull(message = ValidationMessage.DISPUTE_ID_NOT_BLANK)
  @Min(value = 1l, message = ValidationMessage.ILLEGAL_VALUE)
  private Long disputeId;

  /**
   * 案件id
   */
  @NotNull(message = ValidationMessage.ID_CANNOT_BE_EMPTY)
  private Long lawCaseId;

  /**
   * 记录更新案件ID的用户id
   */
  //@NotNull(message = "用户id不可为空")
  private Long userId;

}
