package com.beiming.odr.consultancy.dto.requestdto;

import com.beiming.odr.consultancy.api.ValidationMessage;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Author: chenjt
 * @Description:
 * @Date: Created 2018-07-10 16:37
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class DisputesChatWinReqDTO implements Serializable {

  public DisputesChatWinReqDTO(Long id, String userId) {
    this.id = id;
    this.userId = userId;
  }

  /**
   * 纠纷id
   */
  @NotNull(message = ValidationMessage.DISPUTE_ID_NOT_BLANK)
  @Min(value = 1l, message = ValidationMessage.ILLEGAL_VALUE)
  private Long id;

  @NotNull(message = ValidationMessage.USER_ID_NOT_BLANK)
  private String userId;

  //@NotNull(message = "用户名称不可为空")
  private String userName;

  //@NotNull(message = "用户角色列表不可为空")
  private List<String> roleList;

  //@NotNull(message = "聊天室id")
  private String roomId;

  private String locale;



}
