package com.beiming.odr.consultancy.utils.sm4util;

import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;

/**
 * @author HUAWEI
 * @date 2022/08/23
 * @Description: 国密SM4对称加密算法，此方法需要配合 SM4_Context,SM4,Utils 共同使用
 */

@SuppressWarnings("restriction")
public class SM4Utils {

  /**
   * 当时用ECB模式的时候，和前端key一致
   */
  private static final String SECRET_KEY = "DJodRR_OdR=zHSHL";

  /**
   * 当时用CBC模式的时候，和前端iv一致
   */
  private static final String IV = "ODR_SiNoSOFT=437";


  private static final String UTF_8 = "UTF-8";

  private static final boolean HEX_STRING = false;

  public SM4Utils() {

  }

  /**
   * ECB模式加密
   *
   * @param plainText
   * @return
   */
  public static String encryptDataEcb(String plainText) {
    try {
      SM4Context ctx = new SM4Context();
      ctx.isPadding = true;
      ctx.mode = SM4.SM4_ENCRYPT;

      byte[] keyBytes;
      keyBytes = SECRET_KEY.getBytes();
      SM4 sm4 = new SM4();
      sm4.sm4SetKeyEnc(ctx, keyBytes);
      byte[] encrypted = sm4.sm4CryptEcb(ctx, plainText.getBytes(UTF_8));
      String cipherText = Base64.encodeBase64String(encrypted);
      if (cipherText != null && cipherText.trim().length() > 0) {
        Pattern p = Pattern.compile("\\s*|\t|\r|\n");
        Matcher m = p.matcher(cipherText);
        cipherText = m.replaceAll("");
      }
      return cipherText;
    } catch (Exception e) {
      e.printStackTrace();
      return null;
    }
  }

  /**
   * ECB模式解密
   *
   * @param cipherText
   * @return
   */
  public static String decryptDataEcb(String cipherText) {
    try {
      SM4Context ctx = new SM4Context();
      ctx.isPadding = true;
      ctx.mode = SM4.SM4_DECRYPT;

      byte[] keyBytes;
      keyBytes = SECRET_KEY.getBytes();
      SM4 sm4 = new SM4();
      sm4.sm4SetKeyDec(ctx, keyBytes);
      byte[] decrypted = sm4.sm4CryptEcb(ctx, Base64.decodeBase64(cipherText));
      return new String(decrypted, StandardCharsets.UTF_8);
    } catch (Exception e) {
      e.printStackTrace();
      return null;
    }
  }

  /**
   * CBC模式加密
   *
   * @param plainText
   * @return
   */
  public static String encryptDataCbc(String plainText) {
    try {
      SM4Context ctx = new SM4Context();
      ctx.isPadding = true;
      ctx.mode = SM4.SM4_ENCRYPT;

      byte[] keyBytes;
      byte[] ivBytes;

      keyBytes = SECRET_KEY.getBytes();
      ivBytes = IV.getBytes();

      SM4 sm4 = new SM4();
      sm4.sm4SetKeyEnc(ctx, keyBytes);
      byte[] encrypted = sm4.sm4CryptCbc(ctx, ivBytes, plainText.getBytes(UTF_8));
      String cipherText = Base64.encodeBase64String(encrypted);
      if (cipherText != null && cipherText.trim().length() > 0) {
        Pattern p = Pattern.compile("\\s*|\t|\r|\n");
        Matcher m = p.matcher(cipherText);
        cipherText = m.replaceAll("");
      }
      return cipherText;
    } catch (Exception e) {
      e.printStackTrace();
      return null;
    }
  }

  /**
   * CBC模式解密
   *
   * @param cipherText
   * @return
   */
  public static String decryptDataCbc(String cipherText) {
    try {
      SM4Context ctx = new SM4Context();
      ctx.isPadding = true;
      ctx.mode = SM4.SM4_DECRYPT;

      byte[] keyBytes;
      byte[] ivBytes;
      if (HEX_STRING) {
        keyBytes = Util.hexStringToBytes(SECRET_KEY);
        ivBytes = Util.hexStringToBytes(IV);
      } else {
        keyBytes = SECRET_KEY.getBytes();
        ivBytes = IV.getBytes();
      }

      SM4 sm4 = new SM4();
      sm4.sm4SetKeyDec(ctx, keyBytes);
      byte[] decrypted = sm4.sm4CryptCbc(ctx, ivBytes, Base64.decodeBase64(cipherText));
      return new String(decrypted, StandardCharsets.UTF_8);
    } catch (Exception e) {
      e.printStackTrace();
      return null;
    }
  }

//  public static void main(String[] args) {
//    System.out.println(encryptDataCbc("15295793474"));
//  }
}
