/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.consultancy.utils.sm4util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.enums.APIResultCodeEnums;
import com.beiming.framework.util.AssertUtils;
import com.beiming.odr.consultancy.annotation.EncryptDecryptField;
import com.beiming.odr.consultancy.dto.ParamsDto;
import com.beiming.odr.consultancy.openfeign.EncryptFeignClient;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.Base64Utils;

@Component
public class EncryptDecryptUtilOld {
    @Resource
    private EncryptFeignClient encryptFeignClient;

    private static Boolean checkIsEncrypt(String source) {
        return source.contains("xy_db_encrypt_");
    }

    public <T> T encrypt(Field[] declaredFields, T paramsObject) throws IllegalAccessException {
        for (Field field : declaredFields) {
            EncryptDecryptField sensitiveField = field.getAnnotation(EncryptDecryptField.class);
            if (Objects.isNull(sensitiveField)) continue;
            field.setAccessible(true);
            Object object = field.get(paramsObject);
            if (!(object instanceof String)) continue;
            String value = (String)object;
            String key = field.getName();
            if (StringUtils.isNotEmpty((CharSequence)value) && !EncryptDecryptUtilOld.checkIsEncrypt(value).booleanValue()) {
                ParamsDto paramsDto = new ParamsDto();
                byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
                String s = Base64Utils.encodeToString((byte[])bytes);
                paramsDto.getObj().put(key, s);
                JSONObject resVo = this.encryptFeignClient.encryption(paramsDto);
                AssertUtils.assertTrue((1000 == resVo.getInteger("code") ? 1 : 0) != 0, (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)"\u52a0\u5bc6\u7ed3\u679c\u5931\u8d25");
                JSONObject obj = (JSONObject)JSON.parseObject((String)JSON.toJSONString((Object)resVo.get((Object)"data")), JSONObject.class);
                String encryptValue = obj.get((Object)key).toString();
                field.set(paramsObject, "xy_db_encrypt_" + encryptValue);
                continue;
            }
            field.set(paramsObject, value);
        }
        return paramsObject;
    }

    public <T> T decrypt(T result) throws IllegalAccessException {
        Field[] declaredFields;
        Class<?> resultClass = result.getClass();
        for (Field field : declaredFields = resultClass.getDeclaredFields()) {
            EncryptDecryptField sensitiveField = field.getAnnotation(EncryptDecryptField.class);
            if (Objects.isNull(sensitiveField)) continue;
            field.setAccessible(true);
            Object object = field.get(result);
            if (!(object instanceof String)) continue;
            String value = (String)object;
            String key = field.getName();
            if (StringUtils.isNotEmpty((CharSequence)value) && EncryptDecryptUtilOld.checkIsEncrypt(value).booleanValue()) {
                String data = value.substring(14);
                ParamsDto paramsDto = new ParamsDto();
                paramsDto.getObj().put(key, data);
                System.out.println("====\u89e3\u5bc6\u53c2\u6570====" + paramsDto);
                JSONObject resVo = this.encryptFeignClient.decryption(paramsDto);
                AssertUtils.assertTrue((1000 == resVo.getInteger("code") ? 1 : 0) != 0, (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)"\u89e3\u5bc6\u7ed3\u679c\u5931\u8d25");
                JSONObject obj = (JSONObject)JSON.parseObject((String)JSON.toJSONString((Object)resVo.get((Object)"data")), JSONObject.class);
                String baseValue = obj.get((Object)key).toString();
                byte[] bytes = Base64Utils.decodeFromString((String)baseValue);
                String decryptValue = new String(bytes, StandardCharsets.UTF_8);
                field.set(result, decryptValue);
                continue;
            }
            field.set(result, value);
        }
        return result;
    }
}

