package com.beiming.odr.consultancy.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.consultancy.dto.requestdto.ChangeToCounselorReqDTO;
import com.beiming.odr.consultancy.dto.requestdto.DisputeFileReqDTO;
import com.beiming.odr.consultancy.dto.requestdto.DisputeInfoStatisticsReqDTO;
import com.beiming.odr.consultancy.dto.requestdto.DisputeLawCaseReqDTO;
import com.beiming.odr.consultancy.dto.requestdto.DisputeReqDTO;
import com.beiming.odr.consultancy.dto.requestdto.DisputeReqPageListDTO;
import com.beiming.odr.consultancy.dto.requestdto.DisputeRoomMemberReqDTO;
import com.beiming.odr.consultancy.dto.requestdto.DisputesChatWinReqDTO;
import com.beiming.odr.consultancy.dto.requestdto.DisputesUserRelationReqDTO;
import com.beiming.odr.consultancy.dto.requestdto.PlatMapDisputesCountReqDTO;
import com.beiming.odr.consultancy.dto.response.CounselorDisputesCountMapResDTO;
import com.beiming.odr.consultancy.dto.response.DisputesChatWinResDTO;
import com.beiming.odr.consultancy.dto.response.DisputesResDTO;
import com.beiming.odr.consultancy.dto.response.StatisticsInfoCountDateResDTO;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @Author: chenjt
 * @Description:
 * @Date: Created 2018-06-27 17:12
 */
@Valid
public interface DisputesApi {

  /**
   * 新增纠纷
   * @param disputeReqDTO
   */
  DubboResult<Long> addDispute(@Valid DisputeReqDTO disputeReqDTO);


  /**
   * 人工咨询-证据列表
   * @param disputeId
   * @return
   */
  DubboResult<String> queryDisputeFileJson(@Valid @NotBlank(message = ValidationMessage.DISPUTE_ID_NOT_BLANK) Long disputeId);


  /**
   * 查询咨询列表
   * @param dto
   * @return
   */
  DubboResult<PageInfo<DisputesResDTO>> queryDisputeList(@Valid DisputeReqPageListDTO dto);

  /**
   * 统计咨询师咨询数量
   * @param counselorIds
   * @return
   */
  DubboResult<CounselorDisputesCountMapResDTO> disputesCountByStatusAndCounselorId(@Valid List<String> counselorIds, @Valid @NotBlank(message = ValidationMessage.ORIGIN_NOT_BLANK) String origin);

  /**
   * 查看纠纷详情
   * @param disputeId
   * @return
   */
  DubboResult<DisputesResDTO> queryDispute(@Valid @NotBlank(message = ValidationMessage.DISPUTE_ID_NOT_BLANK) Long disputeId);


  /**
   * 更新纠纷案件ID
   * @param dto
   * @return
   */
  DubboResult<Boolean> updateDisputesLawCaseId(@Valid DisputeLawCaseReqDTO dto);

  /**
   * 用户选择咨询师(在基础服务chat中保存聊天关系)
   * @param dto
   * @return
   */
  DubboResult chooseCounselor(@Valid DisputesUserRelationReqDTO dto);

  /**
   * 查询用户选择的咨询师
   * @param disputeId
   * @return
   */
  DubboResult<String> getUserSelectCounselor(@Valid Long disputeId);

  /**
   * 用户首发聊天信息(保存为待受理状态)
   * @param dto
   * @return roomId
   */
  DubboResult changeStatusToWaitingAccept(@Valid DisputesChatWinReqDTO dto);

  /**
   * 咨询是否能受理(未受理的记录,客服发送首个聊天记录时判断)
   * @param dto
   * @return
   */
  DubboResult<Boolean> canAcceptDispute(@Valid DisputesChatWinReqDTO dto);

  /**
   * 用户首次发消息前需要加入聊天室
   * @param dto
   * @return
   */
  DubboResult customerJoinRoom(@Valid DisputesChatWinReqDTO dto);

  /**
   * 保存受理咨询关系(客服率先回复用户信息)
   * @param dto
   * @return
   */
  DubboResult<Boolean> customerAcceptDispute(@Valid DisputesChatWinReqDTO dto);

  /**
   * 客服转接咨询师
   * @param dto
   * @return
   */
  DubboResult changeToCounselor(@Valid ChangeToCounselorReqDTO dto);

  /**
   * 更新附件(新增或删除,更新json串)
   * @param dto
   * @return
   */
  DubboResult<Boolean> updateDisputesById(@Valid DisputeFileReqDTO dto);

  /**
   * 结束咨询
   * @param dto
   * @return
   */
  DubboResult endDispute(@Valid DisputeRoomMemberReqDTO dto);


  /**
   * 咨询聊天窗口信息
   * @param dto
   * @return
   */
  DubboResult disputesChatWinInfo(@Valid DisputesChatWinReqDTO dto);

  /**
   * 统计用户纠纷数量
   *
   * @param userId 用户Id
   * @return 纠纷数量在data中
   */
  DubboResult countUserDispute(@Valid @NotBlank(message = ValidationMessage.USER_ID_NOT_BLANK) String userId);

  /**
   * 有更新咨询状态,需要设置小红点
   * @param userId
   */
  DubboResult<Boolean> showRedRemind(@Valid @NotBlank(message = ValidationMessage.USER_ID_NOT_BLANK) String userId);

  /**
   * 用户或客服首发聊天信息(保存为客服受理状态)(云律只需要为进行中的状态--客服受理)
   * @param dto
   * @return roomId
   */
  DubboResult<String> changeStatusToRunning(@Valid DisputesChatWinReqDTO dto);


  /**
   * 结束咨询
   * @param dto
   * @return
   */
  DubboResult<Boolean> cloudLawEndDispute(@Valid DisputesChatWinReqDTO dto);


  /**
   * 咨询聊天窗口信息(云律)
   * @param dto
   * @return
   */
  DubboResult<DisputesChatWinResDTO> cloudLawDisputesChatWinInfo(@Valid DisputesChatWinReqDTO dto);

  /**
   * 平台地图统计咨询数量(按纠纷类型和时间查询)
   */
  DubboResult<Integer> platMapDisputeCountListByType(PlatMapDisputesCountReqDTO req);

  /**
   * 咨询总量 报表统计使用
   */
  DubboResult<Integer> disputeCountByAreaCode(@Valid @NotNull(message = ValidationMessage.AREACODE_NOT_BLANK) String areaCode);

  /**
   * XXX业务类型咨询统计
   */
  DubboResult<ArrayList<StatisticsInfoCountDateResDTO>> disputeCountStatisticsList(@Valid DisputeInfoStatisticsReqDTO reqDTO);

  /**
   * 修改纠纷状态
   */
  DubboResult updateDisputeStatus(Long id);
}
