package com.beiming.odr.consultancy.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.consultancy.dto.requestdto.DisputeInfoStatisticsByTypeReqDTO;
import com.beiming.odr.consultancy.dto.requestdto.DisputeInfoStatisticsReqDTO;
import com.beiming.odr.consultancy.dto.requestdto.IntelligentChatCountReqDTO;
import com.beiming.odr.consultancy.dto.requestdto.PlatMapStatisticsReqDTO;
import com.beiming.odr.consultancy.dto.response.DisputesToCaseCountResDTO;
import com.beiming.odr.consultancy.dto.response.IntelligentChatResDTO;
import com.beiming.odr.consultancy.dto.response.StatisticsInfoCountDateResDTO;
import java.util.ArrayList;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

/**
 * @Author: chenjt
 * @Description:
 * @Date: Created 2018-06-27 17:12
 */
@Valid
public interface DisputesStatisticsApi {


  /**
   * 定时任务 取得每天的人工咨询数量统计, 保存入库
   */
  DubboResult everyDayTaskStatisticsDisputes(@Valid @NotNull(message = ValidationMessage.START_TIME_NOT_BLANK) String startDate,
      @Valid @NotNull(message = ValidationMessage.END_TIME_NOT_BLANK) String endDate);

  /**
   * 咨询总量 报表统计使用
   */
  DubboResult<Integer> disputeCountByAreaCode(@Valid @NotNull(message = ValidationMessage.AREACODE_NOT_BLANK) String areaCode);

  /**
   * 平台地图统计咨询数量(按纠纷类型和时间查询)
   */
  DubboResult<Integer> platMapDisputeCountStatisticsListByType(PlatMapStatisticsReqDTO req);

  /**
   * XXX业务类型咨询统计
   */
  DubboResult<ArrayList<StatisticsInfoCountDateResDTO>> disputeCountStatisticsList(@Valid DisputeInfoStatisticsReqDTO reqDTO);

  /**
   * 咨询案件走势分析-咨询转调解(按纠纷类型和时间查询)
   */
  DubboResult<ArrayList<DisputesToCaseCountResDTO>> queryDisputeToCaseCount(DisputeInfoStatisticsByTypeReqDTO req);

  /**
   * 定时任务 取得每天的智能咨询数量统计, 保存入库
   */
  DubboResult everyDayTaskIntelligentChatStatistics(@Valid @NotNull(message = ValidationMessage.START_TIME_NOT_BLANK) String startDate,
      @Valid @NotNull(message = ValidationMessage.END_TIME_NOT_BLANK) String endDate);


  /**
   * 根据地区分组获取智能咨询数量统计
   */
  DubboResult<ArrayList<IntelligentChatResDTO>> getIntelligentChatCountGroutByAreas(@Valid IntelligentChatCountReqDTO dto);

  /**
   * 智能咨询总量 报表统计使用
   */
  DubboResult<Integer> intelligentAllCount();


}
