package com.beiming.odr.consultancy.dto.requestdto;

import com.beiming.odr.consultancy.api.ValidationMessage;
import java.io.Serializable;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Author: chenjt
 * @Description: 客服转接咨询师
 * @Date: Created 2018-07-08 8:56
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class ChangeToCounselorReqDTO implements Serializable {

  private static final long serialVersionUID = -2501838170764078939L;

  @NotNull(message = ValidationMessage.DISPUTE_ID_NOT_BLANK)
  @Min(value = 1l, message = ValidationMessage.ILLEGAL_VALUE)
  private Long id;

  @NotNull(message = ValidationMessage.CUSTOMER_SERVICE_ID_CANNOT_BE_EMPTY)
  @Min(value = 1l, message = ValidationMessage.ILLEGAL_VALUE)
  private Long customerId;

}
