package com.beiming.odr.consultancy.dto.requestdto;

import com.beiming.odr.consultancy.api.ValidationMessage;
import java.io.Serializable;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import lombok.Data;

@Data
public class DisputeChatRoomReqDTO implements Serializable {

  private static final long serialVersionUID = 8984115525518692874L;
  @NotBlank(
      message = ValidationMessage.BUSINESS_TYPE_CANNOT_BE_EMPTY
  )
  protected String subjectType;
  @NotBlank(
      message = ValidationMessage.BUSINESS_ID_CANNOT_BE_EMPTY
  )
  protected String subjectId;
  @NotEmpty(
      message = ValidationMessage.ROOM_MEMBER_IS_NOT_ALLOWED_TO_BE_EMPTY
  )
  @Valid
  protected List<MemberReqDTO> members;

  public DisputeChatRoomReqDTO(String subjectType, String subjectId, List<MemberReqDTO> members) {
    this.subjectType = subjectType;
    this.subjectId = subjectId;
    this.members = members;
  }
}