package com.beiming.odr.consultancy.dto.requestdto;

import com.beiming.odr.consultancy.api.ValidationMessage;
import java.io.Serializable;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Author: chenjt
 * @Description: 客服受理咨询,保存客服的聊天人员关系
 * @Date: Created 2018-06-30 21:18
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class DisputesCustomerRelationReqDTO implements Serializable {


  private static final long serialVersionUID = 452189011567365614L;

  @NotNull(message = ValidationMessage.DISPUTE_ID_NOT_BLANK)
  private String id;

  @NotNull(message = ValidationMessage.CUSTOMER_SERVICE_ID_CANNOT_BE_EMPTY)
  private String customerId;

  @NotNull(message = ValidationMessage.CUSTOMER_SERVICE_NAME_CANNOT_BE_EMPTY)
  private String customerName;

  @NotNull(message = ValidationMessage.CHAT_ROOM_NUMBER)
  private String roomId;

}
