package com.beiming.odr.consultancy.dto.requestdto;

import java.io.Serializable;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Author: chenjt
 * @Description:
 * @Date: Created 2018-07-20 9:38
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class IntelligentChatCountReqDTO implements Serializable {

  /**
   * yyyy-MM-dd HH:mm:ss
   */
  private String startTime;


  private String endTime;

  /**
   * ODR数据库AREAS表中的code
   */
  private String areasCode;


  /**
   * 智能咨询返回的只有数量和区域,没有时间,只能按天查询,增量统计入库
   * @param happenDate
   */
  public IntelligentChatCountReqDTO(String happenDate) {
    this.startTime = happenDate + " 00:00:00";
    this.endTime = happenDate + " 23:59:59";
  }

}
