package com.beiming.odr.consultancy.enums;

/**
 * @Description:纠纷类型枚举类型
 * @Author: chenjt
 * @Date: Created 2018/6/27
 */
public enum DisputeTypeEnum {

  PUBLIC_SECURITY_DISPUTE("治安纠纷"),
  RIGHT_IN_REM_DISPUTE("物权纠纷"),
  TORT_DISPUTE("侵权纠纷"),
  MARITAL_INHERITANCE("婚姻家庭纠纷"),
  CONSUMPTION_RIGHTS("消费纠纷2"),
  LABOUR_DISPUTE("劳动争议纠纷"),
  LOAN_DISPUTE("消费纠纷"),
  PROPERTY_DISPUTE("物业管理纠纷"),
  ADJACENCY_RELATION("邻里纠纷"),
  INTELLECTUAL_PROPERTY_RIGHT("知识产权纠纷"),
  HOUSING_SALE("房屋买卖"),
  HOUSING_RENT("房屋租赁"),
  CONTRACT_DISPUTE("合同纠纷"),
  LAND_MOVE("征地拆迁纠纷"),
  TRAFFIC_ACCIDENT("道路交通事故纠纷"),
  MEDICAL_TANGLE("医疗纠纷"),
  INFRINGEMENT_DISPUTES("侵权纠纷"),
  REAL_RIGHT_DISPUTE("物权纠纷"),
  PARTNERSHIP_JOINT_VENTURE("合伙联营"),
  COMPANY_BUSINESS("公司业务"),
  SECURITIES_BILL("金融消费纠纷"),
  FOREIGN_COMMERCIAL_AFFAIRS("商事纠纷"),
  ADMINISTRATIVE_DISPUTE("行政纠纷"),
  CRIMINAL_SELF_PROSECUTION("刑事自诉"),
  REPUTATION_INFRINGEMENT("名誉侵权"),
  ELECTRONIC_BUSINESS("互联网纠纷"),
  TOURIST_DISPUTES("旅游纠纷"),
  OTHER_DISPUTES("其他纠纷"),
  PETITION_TOWN_BUILD("城乡建设"),
  HOUSE_DISPUTE("房屋宅基地纠纷"),
  VENTURE_DISPUTE("生产经营纠纷"),
  COMPENSAT_DISPUTE("损害赔偿纠纷"),
  LAND_DISPUTE("山林土地纠纷"),
  ENV_DISPUTE("环境污染纠纷"),
  FINANCIAL_LOAN_CONTRACT_DISPUTES("金融借款合同纠纷"),
  PETITION_RURAL_AGRICULTURE("农村农业"),
  PETITION_TERRITORIAL_RESOURCES("国土资源"),
  PETITION_LABOR_SOCIAL_SECURITY("劳动和社会保障"),
  PETITION_ENVIRONMENTAL_PROTECTION("环境保护"),
  PETITION_HEALTH_BIRTH_CONTROL("卫生计生"),
  PETITION_EDUCATIONAL_STYLE("教育文体"),
  PETITION_CIVIL_ADMINISTRATION("民政"),
  PETITION_POLITICAL_LAW("政法"),
  PETITION_TRANSPORTATION("交通运输"),
  PETITION_ORGANIZATION_PERSONNEL("组织人事"),
  PETITION_ECONOMIC_MANAGEMENT("经济管理"),
  PETITION_TECHNOLOGY_INFO_INDUSTRY("科技与信息产业"),
  PETITION_TRADE_TOURISM("商贸旅游"),
  PETITION_PARTY_SERVICE("党务服务"),
  PETITION_DISCIPLINE_INSPECTION_SUPERVISION("纪检监察"),
  PETITION_OTHER("信访其他"),
  NETWORK_COPYRIGHT_NEIGHBORINGRIGHT("网络著作权、邻接权权属纠纷"),
  NETWORK_DOMAINNAME_INFRINGEMENT_CONTRACT("网络域名权属、侵权及合同纠纷"),
  NETWORK_CIVILRIGHT("网络侵害他人人身权、财产权等民事权益纠纷"),
  NETWORK_SHOPPING_CONTRACT("网络购物合同纠纷"),
  NETWORK_SERVICE_CONTRACT("网络服务合同纠纷"),
  NETWORK_PRODUCT_LIABILITY("网络产品责任纠纷"),
  NETWORK_LOAN("网络金融借款合同纠纷"),
  SMALL_LOAN("小额借款合同纠纷"),
  NETWORK_COMMONWEAL_LITIGATION("网络公益诉讼"),
  NETWORK_ADMINISTRATION("网络行政管理引发的行政纠纷"),
  NETWORK_COPYRIGHT_TORT("网络著作权权属、邻接权侵权纠纷"),
  NETWORK_QHZPXXWLCBQJF("侵害作品信息网络传播权纠纷"),
  NETWORK_WLFWHTJF("网络服务合同纠纷"),
  ;

  private String name;
  public static final String LOCALE_NAME_PREF = "consultancy.DisputeTypeEnum.";

  DisputeTypeEnum(String name) {
    this.name = name;
  }

  public String getName() {
    return name;
  }

  public static DisputeTypeEnum batchConvert(String value) {
    DisputeTypeEnum tagEnum = OTHER_DISPUTES;
    DisputeTypeEnum[] values = DisputeTypeEnum.values();
    for (DisputeTypeEnum typeEnum : values) {
      if (typeEnum.getName().equals(value)) {
        tagEnum = typeEnum;
      }
    }
    return tagEnum;
  }
}


