package com.beiming.odr.consultancy.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public class MyHttpClientUtils {

  private static String encoding = "UTF-8";
  private static RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(60000)
      .setConnectTimeout(60000).setConnectionRequestTimeout(60000).build();

  /**
   * 发生 get请求
   *
   * @param header 头信息
   */
  public static String sendHttpDelete(String httpUrl, Map<String, String> header)
      throws IOException {
    HttpDelete httpDelete = new HttpDelete(httpUrl); // 创建get请求
    if (header != null) {
      Set<String> keys = header.keySet();
      for (String key : keys) {
        httpDelete.setHeader(key, header.get(key));
      }
    }
    return sendHttpDelete(httpDelete);
  }

  /**
   * 发送Get请求
   */
  private static String sendHttpDelete(HttpDelete httpDelete) throws IOException {
    CloseableHttpClient httpClient = null;
    CloseableHttpResponse response = null;
    HttpEntity entity = null;
    String responseContent = null;
    try {
      // 创建默认的httpClient实例.
      httpClient = HttpClients.createDefault();
      httpDelete.setConfig(requestConfig);
      // 执行请求
      response = httpClient.execute(httpDelete);
      entity = response.getEntity();
      responseContent = EntityUtils.toString(entity, encoding);
    } catch (Exception e) {
      log.error("GoshawkHttpClientUtils sendHttpGet error {}", e);
    } finally {
      // 关闭连接,释放资源
      if (response != null) {
        response.close();
      }
      if (httpClient != null) {
        httpClient.close();
      }
    }
    return responseContent;
  }

  /**
   * 发送 post请求
   *
   * @param httpUrl 地址
   */
  public static String sendHttpPost(String httpUrl) throws IOException {
    HttpPost httpPost = new HttpPost(httpUrl);
    return sendHttpPost(httpPost);
  }

  /**
   * 发送 post请求
   *
   * @param httpUrl 地址
   * @param json json参数
   */
  public static String sendHttpPost(String httpUrl, String json) throws IOException {
    HttpPost httpPost = new HttpPost(httpUrl);
    httpPost.setEntity(new StringEntity(json, ContentType.APPLICATION_JSON));
    return sendHttpPost(httpPost);
  }

  public static String sendHttpPostAuthorization(String httpUrl, String json, String authorization)
      throws IOException {
    HttpPost httpPost = new HttpPost(httpUrl);
    httpPost.setHeader("authorization", authorization);
    httpPost.setEntity(new StringEntity(json, ContentType.APPLICATION_JSON));
    return sendHttpPost(httpPost);
  }

  public static String sendHttpPost(String httpUrl, String json, Map<String, String> header)
      throws IOException {
    HttpPost httpPost = new HttpPost(httpUrl);
    for (String key : header.keySet()) {
      httpPost.setHeader(key, header.get(key));
    }
    httpPost.setEntity(new StringEntity(json, ContentType.APPLICATION_JSON));
    return sendHttpPost(httpPost);
  }

  public static String sendHttpPost2(String httpUrl, String json, Map<String, String> header)
      throws IOException {
    HttpPost httpPost = new HttpPost(httpUrl);
    for (String key : header.keySet()) {
      httpPost.setHeader(key, header.get(key));
    }
    httpPost.setEntity(new StringEntity(json, ContentType.APPLICATION_FORM_URLENCODED));
    return sendHttpPost(httpPost);
  }

  /**
   * 发送 post请求
   *
   * @param httpUrl 地址
   * @param maps 参数
   */
  public static String sendHttpPost(String httpUrl, Map<String, String> maps) throws IOException {
    HttpPost httpPost = new HttpPost(httpUrl);
    // 创建参数队列
    List<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>();
    for (String key : maps.keySet()) {
      nameValuePairs.add(new BasicNameValuePair(key, maps.get(key)));
    }
    try {
      httpPost.setEntity(new UrlEncodedFormEntity(nameValuePairs, encoding));
    } catch (Exception e) {
      log.error("MyHttpClientUtils sendHttpPost error {}");
    }
    return sendHttpPost(httpPost);
  }


  /**
   * 发送Post请求
   */
  private static String sendHttpPost(HttpPost httpPost) throws IOException {
    CloseableHttpClient httpClient = null;
    CloseableHttpResponse response = null;
    HttpEntity entity = null;
    String responseContent = null;
    try {
      // 创建默认的httpClient实例.
      httpClient = HttpClients.createDefault();
      httpPost.setConfig(requestConfig);
      // 执行请求
      response = httpClient.execute(httpPost);
      entity = response.getEntity();
      responseContent = EntityUtils.toString(entity, encoding);
    } catch (Exception e) {
      log.error("MyHttpClientUtils sendHttpPost error {}", e);
    } finally {
      // 关闭连接,释放资源
      if (response != null) {
        response.close();
      }
      if (httpClient != null) {
        httpClient.close();
      }
    }
    return responseContent;
  }

  /**
   * 发送 get请求
   */
  public static String sendHttpGet(String httpUrl) throws IOException {
    HttpGet httpGet = new HttpGet(httpUrl); // 创建get请求
    return sendHttpGet(httpGet);
  }

  /**
   * 发送 get请求
   */
  public static String sendHttpsGet(String httpUrl) throws IOException {
    HttpGet httpGet = new HttpGet(httpUrl); // 创建get请求
    return sendHttpsGet(httpGet);
  }

  /**
   * 发生 get请求
   *
   * @param header 头信息
   */
  public static String sendHttpGet(String httpUrl, Map<String, String> header) throws IOException {
    HttpGet httpGet = new HttpGet(httpUrl); // 创建get请求
    if (header != null) {
      Set<String> keys = header.keySet();
      for (String key : keys) {
        httpGet.setHeader(key, header.get(key));
      }
    }
    return sendHttpGet(httpGet);
  }

  /**
   * 发生 get请求
   *
   * @param header 头信息
   */
  public static String sendHttpsGet(String httpUrl, Map<String, String> header) throws IOException {
    HttpGet httpGet = new HttpGet(httpUrl); // 创建get请求
    if (header != null) {
      Set<String> keys = header.keySet();
      for (String key : keys) {
        httpGet.setHeader(key, header.get(key));
      }
    }
    return sendHttpsGet(httpGet);
  }

  /**
   * 发送Get请求
   */
  private static String sendHttpsGet(HttpGet httpGet) throws IOException {
    CloseableHttpClient httpClient = null;
    CloseableHttpResponse response = null;
    HttpEntity entity = null;
    String responseContent = null;
    try {
      // 创建默认的httpClient实例.
      httpClient =
          HttpClients.custom().setSSLSocketFactory(SSLConnectionSocketFactory.getSocketFactory())
              .setDefaultRequestConfig(requestConfig).build();
      httpGet.setConfig(requestConfig);
      // 执行请求
      response = httpClient.execute(httpGet);
      entity = response.getEntity();
      responseContent = EntityUtils.toString(entity, encoding);
    } catch (Exception e) {
      log.error("MyHttpClientUtils sendHttpsGet error {}", e);
    } finally {
      // 关闭连接,释放资源
      if (response != null) {
        response.close();
      }
      if (httpClient != null) {
        httpClient.close();
      }

    }
    return responseContent;
  }

  /**
   * 发送Get请求
   */
  private static String sendHttpGet(HttpGet httpGet) throws IOException {
    CloseableHttpClient httpClient = null;
    CloseableHttpResponse response = null;
    HttpEntity entity = null;
    String responseContent = null;
    try {
      // 创建默认的httpClient实例.
      httpClient = HttpClients.createDefault();
      httpGet.setConfig(requestConfig);
      // 执行请求
      response = httpClient.execute(httpGet);
      entity = response.getEntity();
      responseContent = EntityUtils.toString(entity, encoding);
    } catch (Exception e) {
      log.error("MyHttpClientUtils sendHttpGet error {}", e);
    } finally {
      // 关闭连接,释放资源
      if (response != null) {
        response.close();
      }
      if (httpClient != null) {
        httpClient.close();
      }
    }
    return responseContent;
  }
}
