package com.beiming.odr.consultancy.api;

import java.util.ArrayList;
import javax.validation.Valid;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.consultancy.dto.requestdto.HotWordsReqDTO;
import com.beiming.odr.consultancy.dto.requestdto.SearchTypicalCaseReqDTO;
import com.beiming.odr.consultancy.dto.response.TypicalCaseResDTO;

@Valid
public interface TypicalCaseApi {

  /**
   * 搜索典型案例
   * 
   * @param dto
   * @return
   */
  DubboResult<PageInfo<TypicalCaseResDTO>> searchTypicalCase(@Valid SearchTypicalCaseReqDTO dto);

  /**
   * 获取热搜词
   * 
   * @return
   */
  DubboResult<ArrayList<String>> getHotSearchList(@Valid HotWordsReqDTO dto);


}
