package com.beiming.odr.consultancy.dto.requestdto;

import com.beiming.framework.page.PageQuery;
import com.beiming.odr.consultancy.api.ValidationMessage;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * Created by chenjt on 2018/7/2
 */
@Data
public class DisputeReqPageListDTO extends PageQuery implements Serializable {


  private static final long serialVersionUID = 574491743637790726L;

  /**
   * 纠纷编号
   */
  private String disputeNo;

  /**
   * 纠纷类型
   */
  private String disputeType;
  /**
   * 查询列表类型  DisputeQueryStatusEnum枚举类的值
   *   USER_LIST("用户个人咨询列表"),
   *   WAITING_ACCPET("客服未受理"),
   *   CUSTOMER_ACCPET("客服受理未结束"),
   *   CUSTOMER_ACCPET_END("客服受理已结束"),
   *   OTHER_CUSTOMER_ACCPET("他人受理"),
   *   COUNSELOR_ACCPET("咨询师受理中"),
   *   END_COUNSELOR("咨询师受理结束");
   */
  @NotBlank(message = ValidationMessage.QUERY_LIST_TYPE_CANNOT_BE_EMPTY)
  private String disputeQueryStatus;

  /**
   * 用户Id
   */
  private String userId;

  /**
   * 数据来源(人工咨询,智能咨询,云律)
   */
  private String origin;

  private String startDate;

  private String endDate;

  private String userName;

  private String userType;

  private String roleType;

  private String counselorName;


}
