package com.beiming.odr.consultancy.dto.requestdto;

import com.beiming.odr.consultancy.api.ValidationMessage;
import java.io.Serializable;
import javax.validation.constraints.NotBlank;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
@AllArgsConstructor
public class DisputeRoomMemberReqDTO implements Serializable {


  private static final long serialVersionUID = 4004023240922906637L;

  public DisputeRoomMemberReqDTO(Long disputeId, String memberId) {
    this.disputeId = disputeId;
    this.memberId = memberId;
  }

  @NotBlank(message = ValidationMessage.DISPUTE_ID_NOT_BLANK)
  private Long disputeId;

  //@NotBlank(message = "房间id不允许为空")
  /**
   * services层会查询出来赋值
   */
  private String roomId;
  @NotBlank(message = ValidationMessage.MEMBER_ID_CANNOT_BE_EMPTY)
  private String memberId;

}