package com.beiming.odr.consultancy.dto.requestdto;

import com.beiming.odr.consultancy.api.ValidationMessage;
import java.io.Serializable;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Author: chenjt
 * @Description: 选择咨询师,保存聊天人员关系
 * @Date: Created 2018-06-30 21:18
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class DisputesUserRelationReqDTO implements Serializable {


  private static final long serialVersionUID = 460271481158618093L;

  @NotNull(message = ValidationMessage.DISPUTE_ID_NOT_BLANK)
  private String id;

  @NotNull(message = ValidationMessage.USER_ID_NOT_BLANK)
  private String userId;

  @NotNull(message = ValidationMessage.USER_NAME_CANNOT_BE_EMPTY)
  private String userName;

  @NotNull(message = ValidationMessage.CONSULTANT_ID_CANNOT_BE_EMPTY)
  private String counselorId;

  @NotNull(message = ValidationMessage.CONSULTANT_NAME_CANNOT_BE_BLANK)
  private String counselorName;

}
