package com.beiming.odr.consultancy.dto.requestdto;

import com.beiming.odr.consultancy.api.ValidationMessage;
import java.io.Serializable;
import javax.validation.constraints.NotBlank;
import lombok.Data;

/**
 * @Author: chenjt
 * @Description:
 * @Date: Created 2018-07-02 15:15
 */
@Data
public class MemberReqDTO implements Serializable {

  private static final long serialVersionUID = 5565818576144797207L;
  @NotBlank(
      message = ValidationMessage.MEMBER_ID_CANNOT_BE_EMPTY
  )
  private String memberId;
  @NotBlank(
      message = ValidationMessage.MEMBER_NAME_CANNOT_BE_EMPTY
  )
  private String memberName;
  @NotBlank(
      message = ValidationMessage.MEMBER_TYPE_CANNOT_BE_EMPTY
  )
  private String memberType;
  private boolean master;

  public MemberReqDTO(String memberId, String memberName, String memberType) {
    this.memberId = memberId;
    this.memberName = memberName;
    this.memberType = memberType;
  }

  public MemberReqDTO(String memberId, String memberName, String memberType, boolean master) {
    this(memberId, memberName, memberType);
    this.master = master;
  }
}
