package com.beiming.odr.consultancy.dto.requestdto;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import com.beiming.framework.page.PageQuery;
import com.beiming.odr.consultancy.api.ValidationMessage;
import com.beiming.odr.consultancy.enums.TypicalCaseTypeEnums;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
public class SearchTypicalCaseReqDTO extends PageQuery {
  private static final long serialVersionUID = -6570944608841042943L;

  /***
   * 典型案例类型
   */
  @NotNull(message = ValidationMessage.SEARCH_TYPICAL_CASE_TYPE_NOT_NULL)
  private TypicalCaseTypeEnums type;

  /**
   * 搜索词
   */
  @NotEmpty(message = ValidationMessage.SEARCH_KEYS_NOT_EMPTY)
  private String word;

  public SearchTypicalCaseReqDTO(TypicalCaseTypeEnums type, String word) {
    super(1, 10);
    this.type = type;
    this.word = word;
  }

  public SearchTypicalCaseReqDTO(TypicalCaseTypeEnums type, String word, int pageIndex,
      int pageSize) {
    super(pageIndex, pageSize);
    this.type = type;
    this.word = word;
  }
}
