package com.beiming.odr.consultancy.dto.response;

import java.io.Serializable;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Author: chenjt
 * @Description: 定时任务,取得每天的分类纠纷数量统计
 * @Date: Created 2018-07-18 21:31
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class DisputesEveryDayResDTO implements Serializable {


  private static final long serialVersionUID = -662131139395004085L;

  /**
   * 统计数量
   */
  private Integer num;

  /**
   * 咨询转调解数量
   */
  private Integer toCaseNum;

  /**
   * 统计日期
   */
  private String happenDate;

  /**
   * 纠纷类别code
   */
  private String disputeTypeCode;

  /**
   * 纠纷类别名称
   */
  private String disputeTypeName;

  /**
   * 统计咨询地区代码(存储街道code)
   */
  private String areaCode;


}
